/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.cfg.CFG;
import org.sonar.plugins.java.api.tree.Tree;

public class CFGLoop {
    private final CFG.Block startingBlock;
    private final Set<CFG.Block> blocks = new HashSet<CFG.Block>();
    private final Set<CFG.Block> successors = new HashSet<CFG.Block>();

    private CFGLoop(CFG.Block block) {
        this.startingBlock = block;
    }

    private void initialize(CFG.Block block, Map<Tree, CFGLoop> container) {
        CFG.Block loopFirstBlock = block.trueBlock();
        if (loopFirstBlock == null) {
            loopFirstBlock = block.successors().iterator().next();
        }
        this.collectBlocks(loopFirstBlock, container);
        this.successors.addAll(block.successors());
        this.successors.remove(block.falseBlock());
        this.collectWaysOut(container);
    }

    @VisibleForTesting
    CFG.Block startingBlock() {
        return this.startingBlock;
    }

    @VisibleForTesting
    Collection<CFG.Block> blocks() {
        return new ArrayList<CFG.Block>(this.blocks);
    }

    @VisibleForTesting
    Collection<CFG.Block> successors() {
        return new ArrayList<CFG.Block>(this.successors);
    }

    public boolean hasNoWayOut() {
        return this.successors.isEmpty();
    }

    private void collectBlocks(CFG.Block block, Map<Tree, CFGLoop> container) {
        this.collectBlocks(block, container, new HashSet<CFG.Block>());
    }

    private boolean collectBlocks(CFG.Block block, Map<Tree, CFGLoop> container, Set<CFG.Block> visitedBlocks) {
        if (this.blocks.contains(block)) {
            return true;
        }
        if (block.id() == this.startingBlock.id() || !visitedBlocks.add(block)) {
            return false;
        }
        boolean answer = this.returnsToStart(block, container, visitedBlocks);
        if (answer || CFGLoop.isBreak(block)) {
            this.blocks.add(block);
        }
        return answer;
    }

    private boolean returnsToStart(CFG.Block block, Map<Tree, CFGLoop> container, Set<CFG.Block> visitedBlocks) {
        Set<CFG.Block> localSuccessors = CFGLoop.localSuccessors(block, container);
        if (localSuccessors == null) {
            return true;
        }
        boolean answer = false;
        for (CFG.Block successor : localSuccessors) {
            if (this.startingBlock.id() == successor.id()) {
                answer = true;
                continue;
            }
            answer |= this.collectBlocks(successor, container, visitedBlocks);
        }
        return answer;
    }

    @CheckForNull
    private static Set<CFG.Block> localSuccessors(CFG.Block block, Map<Tree, CFGLoop> container) {
        if (CFGLoop.isStarting(block)) {
            CFGLoop loop = container.get(block.terminator());
            if (loop == null) {
                loop = CFGLoop.create(block, container);
            }
            HashSet<CFG.Block> loopSuccessors = new HashSet<CFG.Block>(loop.successors);
            if (block.trueBlock() == null) {
                return null;
            }
            loopSuccessors.add(block.falseBlock());
            return loopSuccessors;
        }
        return block.successors();
    }

    private static boolean isBreak(CFG.Block block) {
        Tree terminator = block.terminator();
        return terminator != null && terminator.is(Tree.Kind.BREAK_STATEMENT);
    }

    private void collectWaysOut(Map<Tree, CFGLoop> container) {
        for (CFG.Block block : this.blocks) {
            if (CFGLoop.isStarting(block)) {
                CFGLoop innerLoop = container.get(block.terminator());
                this.successors.addAll(innerLoop.successors());
                continue;
            }
            this.successors.addAll(block.successors());
        }
        this.successors.removeAll(this.blocks);
        this.successors.remove(this.startingBlock);
    }

    private static boolean isStarting(CFG.Block block) {
        Tree terminator = block.terminator();
        return terminator != null && terminator.is(Tree.Kind.FOR_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_STATEMENT);
    }

    public static Map<Tree, CFGLoop> getCFGLoops(CFG cfg) {
        HashMap<Tree, CFGLoop> cfgLoops = new HashMap<Tree, CFGLoop>();
        for (CFG.Block block : cfg.blocks()) {
            Tree terminator;
            if (!CFGLoop.isStarting(block) || cfgLoops.containsKey(terminator = block.terminator())) continue;
            CFGLoop.create(block, cfgLoops);
        }
        return cfgLoops;
    }

    private static CFGLoop create(CFG.Block block, Map<Tree, CFGLoop> container) {
        CFGLoop loop = new CFGLoop(block);
        container.put(block.terminator(), loop);
        loop.initialize(block, container);
        return loop;
    }
}

