/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.sonar.java.Preconditions;
import org.sonar.java.annotations.Beta;
import org.sonar.java.ast.parser.QualifiedIdentifierListTreeImpl;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JProblem;
import org.sonar.java.model.JSema;
import org.sonar.java.model.JWarning;
import org.sonar.java.model.LineUtils;
import org.sonar.java.model.declaration.AnnotationTreeImpl;
import org.sonar.java.model.expression.AssessableExpressionTree;
import org.sonar.java.model.expression.TypeArgumentListTreeImpl;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportClauseTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.ModuleDeclarationTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeArguments;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.plugins.java.api.tree.WildcardTree;
import org.sonarsource.analyzer.commons.collections.ListUtils;

public abstract class JavaTree
implements Tree {
    protected CompilationUnitTreeImpl root;
    @Nullable
    private Tree parent;
    private List<Tree> children;

    @Override
    @Nullable
    public SyntaxToken firstToken() {
        for (Tree child : this.getChildren()) {
            SyntaxToken first = child.firstToken();
            if (first == null) continue;
            return first;
        }
        return null;
    }

    @Override
    @Nullable
    public SyntaxToken lastToken() {
        List<Tree> trees = this.getChildren();
        for (int index = trees.size() - 1; index >= 0; --index) {
            SyntaxToken last = trees.get(index).lastToken();
            if (last == null) continue;
            return last;
        }
        return null;
    }

    public int getLine() {
        SyntaxToken firstSyntaxToken = this.firstToken();
        if (firstSyntaxToken == null) {
            return -1;
        }
        return LineUtils.startLine(firstSyntaxToken);
    }

    @Override
    public final boolean is(Tree.Kind ... kinds) {
        Tree.Kind treeKind = this.kind();
        for (Tree.Kind kindIter : kinds) {
            if (treeKind != kindIter) continue;
            return true;
        }
        return false;
    }

    @Override
    public Tree parent() {
        return this.parent;
    }

    public void setParent(Tree parent) {
        this.root = ((JavaTree)parent).root;
        this.parent = parent;
    }

    protected abstract List<Tree> children();

    public List<Tree> getChildren() {
        if (this.children == null) {
            this.children = this.children().stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        return this.children;
    }

    public boolean isLeaf() {
        return false;
    }

    public static class CompilationUnitTreeImpl
    extends JavaTree
    implements CompilationUnitTree {
        @Nullable
        private final PackageDeclarationTree packageDeclaration;
        private final List<ImportClauseTree> imports;
        private final List<Tree> types;
        @Nullable
        private final ModuleDeclarationTree moduleDeclaration;
        private final SyntaxToken eofToken;
        public JSema sema;
        private final Map<JProblem.Type, Set<JWarning>> warnings = new EnumMap<JProblem.Type, Set<JWarning>>(JProblem.Type.class);

        public CompilationUnitTreeImpl(@Nullable PackageDeclarationTree packageDeclaration, List<ImportClauseTree> imports, List<Tree> types, @Nullable ModuleDeclarationTree moduleDeclaration, SyntaxToken eofToken) {
            this.root = this;
            this.packageDeclaration = packageDeclaration;
            this.imports = imports;
            this.types = types;
            this.moduleDeclaration = moduleDeclaration;
            this.eofToken = eofToken;
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.COMPILATION_UNIT;
        }

        @Override
        public List<ImportClauseTree> imports() {
            return this.imports;
        }

        @Override
        public List<Tree> types() {
            return this.types;
        }

        @Beta
        public List<JWarning> warnings(JProblem.Type type) {
            return Collections.unmodifiableList(new ArrayList(this.warnings.getOrDefault((Object)type, Collections.emptySet())));
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitCompilationUnit(this);
        }

        @Override
        public List<Tree> children() {
            List packageIterator = this.packageDeclaration == null ? Collections.emptyList() : Collections.singletonList(this.packageDeclaration);
            List moduleIterator = this.moduleDeclaration == null ? Collections.emptyList() : Collections.singletonList(this.moduleDeclaration);
            return ListUtils.concat((Iterable[])new Iterable[]{packageIterator, this.imports, this.types, moduleIterator, Collections.singletonList(this.eofToken)});
        }

        @Override
        @Nullable
        public PackageDeclarationTree packageDeclaration() {
            return this.packageDeclaration;
        }

        @Override
        @Nullable
        public ModuleDeclarationTree moduleDeclaration() {
            return this.moduleDeclaration;
        }

        @Override
        public SyntaxToken eofToken() {
            return this.eofToken;
        }

        public void addWarnings(Map<JProblem.Type, Set<JWarning>> warnings) {
            this.warnings.putAll(warnings);
        }
    }

    public static interface AnnotatedTypeTree
    extends TypeTree {
        public void complete(List<AnnotationTree> var1);
    }

    public static class ArrayTypeTreeImpl
    extends AssessableExpressionTree
    implements ArrayTypeTree,
    AnnotatedTypeTree {
        private TypeTree type;
        private List<AnnotationTree> annotations;
        private final InternalSyntaxToken openBracketToken;
        private final InternalSyntaxToken closeBracketToken;
        private final InternalSyntaxToken ellipsisToken;

        public ArrayTypeTreeImpl(@Nullable TypeTree type, List<AnnotationTreeImpl> annotations, InternalSyntaxToken openBracketToken, InternalSyntaxToken closeBracketToken) {
            this.type = type;
            this.annotations = Collections.unmodifiableList(annotations);
            this.openBracketToken = openBracketToken;
            this.closeBracketToken = closeBracketToken;
            this.ellipsisToken = null;
        }

        public ArrayTypeTreeImpl(@Nullable TypeTree type, List<AnnotationTreeImpl> annotations, InternalSyntaxToken ellispsisToken) {
            this.type = type;
            this.annotations = Collections.unmodifiableList(annotations);
            this.openBracketToken = null;
            this.closeBracketToken = null;
            this.ellipsisToken = ellispsisToken;
        }

        public void completeType(TypeTree type) {
            this.type = type;
        }

        public void setLastChildType(TypeTree type) {
            ArrayTypeTree childType = this;
            while (childType.type() != null && childType.is(Tree.Kind.ARRAY_TYPE)) {
                childType = (ArrayTypeTree)childType.type();
            }
            childType.completeType(type);
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.ARRAY_TYPE;
        }

        @Override
        public TypeTree type() {
            return this.type;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitArrayType(this);
        }

        @Override
        public List<Tree> children() {
            boolean hasBrackets = this.ellipsisToken == null;
            return ListUtils.concat((List[])new List[]{Collections.singletonList(this.type), this.annotations, hasBrackets ? Arrays.asList(this.openBracketToken, this.closeBracketToken) : Collections.singletonList(this.ellipsisToken)});
        }

        @Override
        public List<AnnotationTree> annotations() {
            return this.annotations;
        }

        @Override
        public SyntaxToken openBracketToken() {
            return this.openBracketToken;
        }

        @Override
        public SyntaxToken closeBracketToken() {
            return this.closeBracketToken;
        }

        @Override
        public SyntaxToken ellipsisToken() {
            return this.ellipsisToken;
        }

        @Override
        public void complete(List<AnnotationTree> typeAnnotations) {
            this.annotations = typeAnnotations;
        }
    }

    public static class ParameterizedTypeTreeImpl
    extends AssessableExpressionTree
    implements ParameterizedTypeTree,
    AnnotatedTypeTree {
        private final TypeTree type;
        private final TypeArguments typeArguments;
        private List<AnnotationTree> annotations;

        public ParameterizedTypeTreeImpl(TypeTree type, TypeArgumentListTreeImpl typeArguments) {
            this.type = Objects.requireNonNull(type);
            this.typeArguments = Objects.requireNonNull(typeArguments);
            this.annotations = Collections.emptyList();
        }

        @Override
        public void complete(List<AnnotationTree> annotations) {
            this.annotations = annotations;
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.PARAMETERIZED_TYPE;
        }

        @Override
        public TypeTree type() {
            return this.type;
        }

        @Override
        public TypeArguments typeArguments() {
            return this.typeArguments;
        }

        @Override
        public List<AnnotationTree> annotations() {
            return this.annotations;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitParameterizedType(this);
        }

        @Override
        public List<Tree> children() {
            return ListUtils.concat((List[])new List[]{this.annotations, Arrays.asList(this.type, this.typeArguments)});
        }
    }

    public static class PrimitiveTypeTreeImpl
    extends AssessableExpressionTree
    implements PrimitiveTypeTree,
    AnnotatedTypeTree {
        private final InternalSyntaxToken token;
        private List<AnnotationTree> annotations;

        public PrimitiveTypeTreeImpl(InternalSyntaxToken token) {
            this.token = token;
            this.annotations = Collections.emptyList();
        }

        @Override
        public void complete(List<AnnotationTree> annotations) {
            this.annotations = annotations;
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.PRIMITIVE_TYPE;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitPrimitiveType(this);
        }

        @Override
        public SyntaxToken keyword() {
            return this.token;
        }

        @Override
        public List<Tree> children() {
            return ListUtils.concat((List[])new List[]{this.annotations, Collections.singletonList(this.token)});
        }

        @Override
        public List<AnnotationTree> annotations() {
            return this.annotations;
        }
    }

    public static class NotImplementedTreeImpl
    extends AssessableExpressionTree {
        @Override
        public Tree.Kind kind() {
            return Tree.Kind.OTHER;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitOther(this);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public List<Tree> children() {
            throw new UnsupportedOperationException();
        }
    }

    public static class UnionTypeTreeImpl
    extends AbstractTypedTree
    implements UnionTypeTree {
        private final ListTree<TypeTree> typeAlternatives;

        public UnionTypeTreeImpl(QualifiedIdentifierListTreeImpl typeAlternatives) {
            this.typeAlternatives = Objects.requireNonNull(typeAlternatives);
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.UNION_TYPE;
        }

        @Override
        public ListTree<TypeTree> typeAlternatives() {
            return this.typeAlternatives;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitUnionType(this);
        }

        @Override
        public List<Tree> children() {
            return Collections.singletonList(this.typeAlternatives);
        }

        @Override
        public List<AnnotationTree> annotations() {
            return Collections.emptyList();
        }
    }

    public static class WildcardTreeImpl
    extends AbstractTypedTree
    implements WildcardTree,
    AnnotatedTypeTree {
        private SyntaxToken queryToken;
        @Nullable
        private final SyntaxToken extendsOrSuperToken;
        private final Tree.Kind kind;
        @Nullable
        private final TypeTree bound;
        private List<AnnotationTree> annotations;

        public WildcardTreeImpl(InternalSyntaxToken queryToken) {
            this.kind = Tree.Kind.UNBOUNDED_WILDCARD;
            this.annotations = Collections.emptyList();
            this.queryToken = queryToken;
            this.extendsOrSuperToken = null;
            this.bound = null;
        }

        public WildcardTreeImpl(Tree.Kind kind, InternalSyntaxToken extendsOrSuperToken, TypeTree bound) {
            Preconditions.checkState(kind == Tree.Kind.EXTENDS_WILDCARD || kind == Tree.Kind.SUPER_WILDCARD);
            this.kind = kind;
            this.annotations = Collections.emptyList();
            this.extendsOrSuperToken = extendsOrSuperToken;
            this.bound = bound;
        }

        public WildcardTreeImpl complete(InternalSyntaxToken queryToken) {
            Preconditions.checkState(this.kind == Tree.Kind.EXTENDS_WILDCARD || this.kind == Tree.Kind.SUPER_WILDCARD);
            this.queryToken = queryToken;
            return this;
        }

        @Override
        public void complete(List<AnnotationTree> annotations) {
            this.annotations = annotations;
        }

        @Override
        public Tree.Kind kind() {
            return this.kind;
        }

        @Override
        public List<AnnotationTree> annotations() {
            return this.annotations;
        }

        @Override
        public SyntaxToken queryToken() {
            return this.queryToken;
        }

        @Override
        @Nullable
        public SyntaxToken extendsOrSuperToken() {
            return this.extendsOrSuperToken;
        }

        @Override
        @Nullable
        public TypeTree bound() {
            return this.bound;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitWildcard(this);
        }

        @Override
        public List<Tree> children() {
            ArrayList<AnnotationTree> builder = new ArrayList<AnnotationTree>(this.annotations);
            builder.add((AnnotationTree)((Object)this.queryToken));
            if (this.bound != null) {
                builder.add((AnnotationTree)((Object)this.extendsOrSuperToken));
                builder.add((AnnotationTree)((Object)this.bound));
            }
            return Collections.unmodifiableList(builder);
        }
    }

    public static class ImportTreeImpl
    extends JavaTree
    implements ImportTree {
        private final boolean isStatic;
        private final Tree qualifiedIdentifier;
        private final SyntaxToken semicolonToken;
        private final SyntaxToken importToken;
        private final SyntaxToken staticToken;
        public IBinding binding;

        public ImportTreeImpl(InternalSyntaxToken importToken, @Nullable InternalSyntaxToken staticToken, Tree qualifiedIdentifier, InternalSyntaxToken semiColonToken) {
            this.importToken = importToken;
            this.staticToken = staticToken;
            this.qualifiedIdentifier = qualifiedIdentifier;
            this.semicolonToken = semiColonToken;
            this.isStatic = staticToken != null;
        }

        @Nullable
        public Symbol symbol() {
            if (this.binding != null) {
                switch (this.binding.getKind()) {
                    case 2: {
                        return this.root.sema.typeSymbol((ITypeBinding)this.binding);
                    }
                    case 4: {
                        return this.root.sema.methodSymbol((IMethodBinding)this.binding);
                    }
                    case 3: {
                        return this.root.sema.variableSymbol((IVariableBinding)this.binding);
                    }
                }
            }
            return null;
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.IMPORT;
        }

        @Override
        public boolean isStatic() {
            return this.isStatic;
        }

        @Override
        public SyntaxToken importKeyword() {
            return this.importToken;
        }

        @Override
        @Nullable
        public SyntaxToken staticKeyword() {
            return this.staticToken;
        }

        @Override
        public Tree qualifiedIdentifier() {
            return this.qualifiedIdentifier;
        }

        @Override
        public SyntaxToken semicolonToken() {
            return this.semicolonToken;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitImport(this);
        }

        @Override
        public List<Tree> children() {
            return ListUtils.concat((List[])new List[]{Collections.singletonList(this.importToken), this.isStatic ? Collections.singletonList(this.staticToken) : Collections.emptyList(), Arrays.asList(this.qualifiedIdentifier, this.semicolonToken)});
        }
    }

    public static class PackageDeclarationTreeImpl
    extends JavaTree
    implements PackageDeclarationTree {
        private final List<AnnotationTree> annotations;
        private final SyntaxToken packageKeyword;
        private final ExpressionTree packageName;
        private final SyntaxToken semicolonToken;

        public PackageDeclarationTreeImpl(List<AnnotationTree> annotations, SyntaxToken packageKeyword, ExpressionTree packageName, SyntaxToken semicolonToken) {
            this.annotations = Objects.requireNonNull(annotations);
            this.packageKeyword = packageKeyword;
            this.packageName = packageName;
            this.semicolonToken = semicolonToken;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitPackage(this);
        }

        @Override
        public List<AnnotationTree> annotations() {
            return this.annotations;
        }

        @Override
        public SyntaxToken packageKeyword() {
            return this.packageKeyword;
        }

        @Override
        public ExpressionTree packageName() {
            return this.packageName;
        }

        @Override
        public SyntaxToken semicolonToken() {
            return this.semicolonToken;
        }

        @Override
        public Tree.Kind kind() {
            return Tree.Kind.PACKAGE;
        }

        @Override
        public List<Tree> children() {
            return ListUtils.concat((List[])new List[]{this.annotations, Arrays.asList(this.packageKeyword, this.packageName, this.semicolonToken)});
        }

        public static String packageNameAsString(@Nullable PackageDeclarationTree tree) {
            if (tree == null) {
                return "";
            }
            LinkedList<String> pieces = new LinkedList<String>();
            ExpressionTree expr = tree.packageName();
            while (expr.is(Tree.Kind.MEMBER_SELECT)) {
                MemberSelectExpressionTree mse = (MemberSelectExpressionTree)expr;
                pieces.push(mse.identifier().name());
                pieces.push(mse.operatorToken().text());
                expr = mse.expression();
            }
            if (expr.is(Tree.Kind.IDENTIFIER)) {
                IdentifierTree idt = (IdentifierTree)expr;
                pieces.push(idt.name());
            }
            StringBuilder sb = new StringBuilder();
            for (String piece : pieces) {
                sb.append(piece);
            }
            return sb.toString();
        }
    }
}

