/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.caching;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.sonar.api.batch.fs.InputFile;

public class FileHashingUtils {
    public static final String HASH_ALGORITHM = "MD5";

    private FileHashingUtils() {
    }

    public static byte[] inputFileContentHash(InputFile inputFile) throws IOException, NoSuchAlgorithmException {
        byte[] contentBytes = inputFile.contents().getBytes(StandardCharsets.UTF_8);
        MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGORITHM);
        return messageDigest.digest(contentBytes);
    }

    public static byte[] inputFileContentHash(String filepath) throws IOException, NoSuchAlgorithmException {
        File file = new File(filepath);
        String contents = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGORITHM);
        return messageDigest.digest(contents.getBytes(StandardCharsets.UTF_8));
    }
}

