/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.reporting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaTextEdit;

public class JavaQuickFix {
    private final String description;
    private final List<JavaTextEdit> textEdits;

    private JavaQuickFix(String description, List<JavaTextEdit> textEdits) {
        this.description = description;
        this.textEdits = textEdits;
    }

    public String getDescription() {
        return this.description;
    }

    public List<JavaTextEdit> getTextEdits() {
        return this.textEdits;
    }

    public static Builder newQuickFix(String description) {
        return new Builder(description);
    }

    public static Builder newQuickFix(String description, Object ... args) {
        return new Builder(String.format(description, args));
    }

    public static class Builder {
        private final String description;
        private final List<JavaTextEdit> textEdits = new ArrayList<JavaTextEdit>();

        private Builder(String description) {
            this.description = description;
        }

        public Builder addTextEdit(JavaTextEdit ... textEdit) {
            this.textEdits.addAll(Arrays.asList(textEdit));
            return this;
        }

        public Builder addTextEdits(List<JavaTextEdit> textEdits) {
            this.textEdits.addAll(textEdits);
            return this;
        }

        public Builder reverseSortEdits() {
            this.textEdits.sort(new TreeSorter().reversed());
            return this;
        }

        public JavaQuickFix build() {
            return new JavaQuickFix(this.description, this.textEdits);
        }

        private static class TreeSorter
        implements Comparator<JavaTextEdit> {
            private TreeSorter() {
            }

            @Override
            public int compare(JavaTextEdit a, JavaTextEdit b) {
                AnalyzerMessage.TextSpan first = a.getTextSpan();
                AnalyzerMessage.TextSpan second = b.getTextSpan();
                int result = first.startLine - second.startLine;
                if (result != 0) {
                    return result;
                }
                result = first.startCharacter - second.startCharacter;
                if (result != 0) {
                    return result;
                }
                result = first.endLine - second.endLine;
                if (result != 0) {
                    return result;
                }
                return first.endCharacter - second.endCharacter;
            }
        }
    }
}

