/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.cfg;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.cfg.CFG;
import org.sonar.java.cfg.VariableReadExtractor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.collections.ListUtils;
import org.sonarsource.analyzer.commons.collections.SetUtils;

public class LiveVariables {
    private final CFG cfg;
    private final Map<CFG.Block, Set<Symbol>> out = new HashMap<CFG.Block, Set<Symbol>>();
    private final Map<CFG.Block, Set<Symbol>> in = new HashMap<CFG.Block, Set<Symbol>>();
    private final boolean includeFields;

    private LiveVariables(CFG cfg, boolean includeFields) {
        this.cfg = cfg;
        this.includeFields = includeFields;
    }

    public Set<Symbol> getOut(CFG.Block block) {
        return this.out.get(block);
    }

    public Set<Symbol> getIn(CFG.Block block) {
        return this.in.get(block);
    }

    public static LiveVariables analyze(CFG cfg) {
        return LiveVariables.analyze(cfg, false);
    }

    public static LiveVariables analyzeWithFields(CFG cfg) {
        return LiveVariables.analyze(cfg, true);
    }

    private static LiveVariables analyze(CFG cfg, boolean includeFields) {
        LiveVariables liveVariables = new LiveVariables(cfg, includeFields);
        HashMap<CFG.Block, Set<Symbol>> kill = new HashMap<CFG.Block, Set<Symbol>>();
        HashMap<CFG.Block, Set<Symbol>> gen = new HashMap<CFG.Block, Set<Symbol>>();
        for (CFG.Block block : liveVariables.cfg.reversedBlocks()) {
            HashSet<Symbol> blockKill = new HashSet<Symbol>();
            HashSet<Symbol> blockGen = new HashSet<Symbol>();
            liveVariables.processBlockElements(block, blockKill, blockGen);
            kill.put(block, blockKill);
            gen.put(block, blockGen);
        }
        liveVariables.analyzeCFG(liveVariables.in, kill, gen);
        if (!liveVariables.out.get(liveVariables.cfg.reversedBlocks().get(0)).isEmpty()) {
            throw new IllegalStateException("Out of exit block should be empty");
        }
        for (Map.Entry entry : liveVariables.out.entrySet()) {
            entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
        }
        return liveVariables;
    }

    private void analyzeCFG(Map<CFG.Block, Set<Symbol>> in, Map<CFG.Block, Set<Symbol>> kill, Map<CFG.Block, Set<Symbol>> gen) {
        LinkedList<CFG.Block> workList = new LinkedList<CFG.Block>();
        workList.addAll(this.cfg.reversedBlocks());
        while (!workList.isEmpty()) {
            CFG.Block block = (CFG.Block)workList.removeFirst();
            Set blockOut = this.out.computeIfAbsent(block, k -> new HashSet());
            block.successors().stream().map(in::get).filter(Objects::nonNull).forEach(blockOut::addAll);
            block.exceptions().stream().map(in::get).filter(Objects::nonNull).forEach(blockOut::addAll);
            HashSet newIn = new HashSet(gen.get(block));
            newIn.addAll(SetUtils.difference((Set)blockOut, kill.get(block)));
            if (newIn.equals(in.get(block))) continue;
            in.put(block, newIn);
            block.predecessors().forEach(workList::addLast);
        }
    }

    private void processBlockElements(CFG.Block block, Set<Symbol> blockKill, Set<Symbol> blockGen) {
        HashSet<Tree> assignmentLHS = new HashSet<Tree>();
        for (Tree element : ListUtils.reverse(block.elements())) {
            switch (element.kind()) {
                case ASSIGNMENT: {
                    this.processAssignment((AssignmentExpressionTree)element, blockKill, blockGen, assignmentLHS);
                    break;
                }
                case IDENTIFIER: {
                    this.processIdentifier((IdentifierTree)element, blockGen, assignmentLHS);
                    break;
                }
                case MEMBER_SELECT: {
                    this.processMemberSelect((MemberSelectExpressionTree)element, assignmentLHS, blockGen);
                    break;
                }
                case VARIABLE: {
                    blockKill.add(((VariableTree)element).symbol());
                    blockGen.remove(((VariableTree)element).symbol());
                    break;
                }
                case LAMBDA_EXPRESSION: {
                    blockGen.addAll(this.getUsedVariables(((LambdaExpressionTree)element).body(), this.cfg.methodSymbol()));
                    break;
                }
                case METHOD_REFERENCE: {
                    blockGen.addAll(this.getUsedVariables(((MethodReferenceTree)element).expression(), this.cfg.methodSymbol()));
                    break;
                }
                case NEW_CLASS: {
                    blockGen.addAll(this.getUsedVariables(((NewClassTree)element).classBody(), this.cfg.methodSymbol()));
                    break;
                }
            }
        }
    }

    private void processIdentifier(IdentifierTree element, Set<Symbol> blockGen, Set<Tree> assignmentLHS) {
        Symbol symbol = element.symbol();
        if (!assignmentLHS.contains(element) && this.includeSymbol(symbol)) {
            blockGen.add(symbol);
        }
    }

    private void processMemberSelect(MemberSelectExpressionTree element, Set<Tree> assignmentLHS, Set<Symbol> blockGen) {
        Symbol symbol;
        if (!assignmentLHS.contains(element) && this.includeFields && (symbol = LiveVariables.getField(element)) != null) {
            blockGen.add(symbol);
        }
    }

    private void processAssignment(AssignmentExpressionTree element, Set<Symbol> blockKill, Set<Symbol> blockGen, Set<Tree> assignmentLHS) {
        Symbol symbol = null;
        ExpressionTree lhs = element.variable();
        if (lhs.is(Tree.Kind.IDENTIFIER)) {
            symbol = ((IdentifierTree)lhs).symbol();
        } else if (this.includeFields && lhs.is(Tree.Kind.MEMBER_SELECT)) {
            symbol = LiveVariables.getField((MemberSelectExpressionTree)lhs);
        }
        if (symbol != null && this.includeSymbol(symbol)) {
            assignmentLHS.add(lhs);
            blockGen.remove(symbol);
            blockKill.add(symbol);
        }
    }

    private boolean includeSymbol(Symbol symbol) {
        return symbol.isLocalVariable() || this.includeFields && LiveVariables.isField(symbol);
    }

    private static boolean isField(Symbol symbol) {
        return symbol.owner().isTypeSymbol() && !"this".equals(symbol.name()) && symbol.isVariableSymbol();
    }

    @CheckForNull
    private static Symbol getField(MemberSelectExpressionTree memberSelect) {
        Symbol symbol = memberSelect.identifier().symbol();
        if (memberSelect.expression().is(Tree.Kind.IDENTIFIER)) {
            String objectName = ((IdentifierTree)memberSelect.expression()).name();
            if (symbol.isStatic() || "this".equals(objectName)) {
                return symbol;
            }
        } else if (symbol.isStatic()) {
            return symbol;
        }
        return null;
    }

    private Set<Symbol> getUsedVariables(@Nullable Tree syntaxNode, Symbol.MethodSymbol owner) {
        if (syntaxNode == null) {
            return Collections.emptySet();
        }
        VariableReadExtractor extractorFromClass = new VariableReadExtractor(owner, this.includeFields);
        syntaxNode.accept(extractorFromClass);
        return extractorFromClass.usedVariables();
    }
}

