/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.testing;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.java.Preconditions;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;

public class JavaIssueBuilderForTests
extends InternalJavaIssueBuilder {
    private final Set<AnalyzerMessage> issues;
    private final Map<AnalyzerMessage.TextSpan, List<JavaQuickFix>> quickFixes;
    private boolean reported;

    public JavaIssueBuilderForTests(InputFile inputFile, Set<AnalyzerMessage> issues, Map<AnalyzerMessage.TextSpan, List<JavaQuickFix>> quickFixes) {
        super(inputFile, null);
        this.issues = issues;
        this.reported = false;
        this.quickFixes = quickFixes;
    }

    @Override
    public void report() {
        Preconditions.checkState(!this.reported, "Can only be reported once.");
        JavaCheck rule = this.rule();
        InputFile inputFile = this.inputFile();
        AnalyzerMessage.TextSpan textSpan = this.textSpan();
        AnalyzerMessage issue = new AnalyzerMessage(rule, (InputComponent)inputFile, textSpan, this.message(), (int)this.cost().orElse(0));
        this.secondaries().map(JavaIssueBuilderForTests::toSingletonList).map(secondaries -> JavaIssueBuilderForTests.listOfLocationsToListOfAnalyzerMessages(secondaries, rule, inputFile)).ifPresent(issue.flows::addAll);
        this.flows().map(flows -> JavaIssueBuilderForTests.listOfLocationsToListOfAnalyzerMessages(flows, rule, inputFile)).ifPresent(issue.flows::addAll);
        this.quickFixes.put(textSpan, this.quickFixes().stream().map(Supplier::get).flatMap(Collection::stream).toList());
        this.issues.add(issue);
        this.reported = true;
    }

    private static List<List<JavaFileScannerContext.Location>> toSingletonList(List<JavaFileScannerContext.Location> secondaries) {
        return secondaries.stream().map(Collections::singletonList).toList();
    }

    private static List<List<AnalyzerMessage>> listOfLocationsToListOfAnalyzerMessages(List<List<JavaFileScannerContext.Location>> locations, JavaCheck rule, InputFile inputFile) {
        return locations.stream().map(listOfLocations -> JavaIssueBuilderForTests.locationsToAnalyzerMessages(listOfLocations, rule, inputFile)).toList();
    }

    private static List<AnalyzerMessage> locationsToAnalyzerMessages(List<JavaFileScannerContext.Location> locations, JavaCheck rule, InputFile inputFile) {
        return locations.stream().map(location -> JavaIssueBuilderForTests.locationToAnalyzerMessage(location, rule, inputFile)).toList();
    }

    private static AnalyzerMessage locationToAnalyzerMessage(JavaFileScannerContext.Location location, JavaCheck rule, InputFile inputFile) {
        return new AnalyzerMessage(rule, (InputComponent)inputFile, AnalyzerMessage.textSpanFor(location.syntaxNode), location.msg, 0);
    }
}

