/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.classpath;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;
import org.sonar.java.annotations.VisibleForTesting;

public class JavaSdkUtil {
    private static final String LIB_JRT_FS_JAR = "lib/jrt-fs.jar";
    private static final String ENDORSED = "endorsed";

    private JavaSdkUtil() {
    }

    public static List<File> getJdkClassesRoots(Path home) {
        return JavaSdkUtil.getJdkClassesRoots(home, SystemUtils.IS_OS_MAC);
    }

    @VisibleForTesting
    static List<File> getJdkClassesRoots(Path home, boolean isMac) {
        if (JavaSdkUtil.isModularRuntime(home)) {
            return Collections.singletonList(home.resolve(LIB_JRT_FS_JAR).toFile());
        }
        ArrayList<File> rootFiles = new ArrayList<File>();
        rootFiles.addAll(JavaSdkUtil.collectJars(home, isMac));
        return rootFiles;
    }

    private static List<File> collectJars(Path home, boolean isMac) {
        ArrayList<File> rootFiles = new ArrayList<File>();
        HashSet duplicatePathFilter = new HashSet();
        for (Path jarDir : JavaSdkUtil.collectJarDirs(home, isMac)) {
            if (!Files.isDirectory(jarDir, new LinkOption[0])) continue;
            JavaSdkUtil.listFiles(jarDir, JavaSdkUtil::isJarFile).stream().filter(JavaSdkUtil::isNotAlternativeImplementation).map(JavaSdkUtil::toRealPath).filter(Optional::isPresent).map(Optional::get).forEach(jarFile -> {
                if (duplicatePathFilter.add(jarFile)) {
                    rootFiles.add(jarFile.toFile());
                }
            });
        }
        return rootFiles;
    }

    private static boolean isJarFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".jar");
    }

    private static boolean isNotAlternativeImplementation(Path jarPath) {
        String jarFileName = jarPath.getFileName().toString();
        return !jarFileName.equals("alt-rt.jar") && !jarFileName.equals("alt-string.jar");
    }

    private static Path[] collectJarDirs(Path home, boolean isMac) {
        ArrayList<Path> jarDirs = new ArrayList<Path>();
        if (isMac) {
            Path openJdkRtJar = home.resolve("jre/lib/rt.jar");
            if (Files.isRegularFile(openJdkRtJar, new LinkOption[0])) {
                Path libDir = home.resolve("lib");
                Path classesDir = openJdkRtJar.getParent();
                Path libExtDir = openJdkRtJar.getParent().resolve("ext");
                Path libEndorsedDir = libDir.resolve(ENDORSED);
                jarDirs.addAll(List.of(libEndorsedDir, libDir, classesDir, libExtDir));
            } else {
                Path libDir = home.resolve("lib");
                Path classesDir = home.getParent().resolve("Classes");
                Path libExtDir = libDir.resolve("ext");
                Path libEndorsedDir = libDir.resolve(ENDORSED);
                jarDirs.addAll(List.of(libEndorsedDir, libDir, classesDir, libExtDir));
            }
        } else {
            Path libDir = home.resolve("jre/lib");
            if (!Files.isDirectory(libDir, new LinkOption[0])) {
                libDir = home.resolve("lib");
            }
            Path libExtDir = libDir.resolve("ext");
            Path libEndorsedDir = libDir.resolve(ENDORSED);
            jarDirs.addAll(List.of(libEndorsedDir, libDir, libExtDir));
        }
        JavaSdkUtil.getIbmDir(home).ifPresent(jarDirs::add);
        return jarDirs.toArray(new Path[0]);
    }

    private static boolean isModularRuntime(Path home) {
        return Files.exists(home.resolve(LIB_JRT_FS_JAR), new LinkOption[0]);
    }

    private static Set<Path> listFiles(Path dir, Predicate<Path> filter) {
        Set<Path> set;
        block8: {
            Stream<Path> stream = Files.walk(dir, 1, new FileVisitOption[0]);
            try {
                set = stream.filter(filter).collect(Collectors.toSet());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Collections.emptySet();
                }
            }
            stream.close();
        }
        return set;
    }

    private static Optional<Path> toRealPath(Path file) {
        try {
            return Optional.of(file.toRealPath(new LinkOption[0]));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private static Optional<Path> getIbmDir(Path home) {
        Path jclSC180Dir = home.resolve(Paths.get("jre", "lib", "amd64", "default", "jclSC180"));
        if (Files.isDirectory(jclSC180Dir, new LinkOption[0])) {
            return Optional.of(jclSC180Dir);
        }
        jclSC180Dir = home.resolve(Paths.get("bin", "default", "jclSC180"));
        if (Files.isDirectory(jclSC180Dir, new LinkOption[0])) {
            return Optional.of(jclSC180Dir);
        }
        return Optional.empty();
    }
}

