/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.ExecutionTimeReport;
import org.sonar.java.ProgressMonitor;
import org.sonar.java.model.JParser;
import org.sonar.java.model.JProblem;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonarsource.analyzer.commons.ProgressReport;
import org.sonarsource.performance.measure.PerformanceMeasure;

public abstract class JParserConfig {
    public static final String MAXIMUM_SUPPORTED_JAVA_VERSION = Integer.toString(17);
    private static final Logger LOG = Loggers.get(JParserConfig.class);
    private static final String MAXIMUM_ECJ_WARNINGS = "42000";
    private static final Set<String> JRE_JARS = new HashSet<String>(Arrays.asList("rt.jar", "jrt-fs.jar", "android.jar"));
    final String javaVersion;
    final List<File> classpath;

    private JParserConfig(String javaVersion, List<File> classpath) {
        this.javaVersion = javaVersion;
        this.classpath = classpath;
    }

    public abstract void parse(Iterable<? extends InputFile> var1, BooleanSupplier var2, BiConsumer<InputFile, Result> var3);

    public ASTParser astParser() {
        ASTParser astParser = ASTParser.newParser((int)AST.getJLSLatest());
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.eclipse.jdt.core.compiler.compliance", this.javaVersion);
        options.put("org.eclipse.jdt.core.compiler.source", this.javaVersion);
        options.put("org.eclipse.jdt.core.compiler.maxProblemPerUnit", MAXIMUM_ECJ_WARNINGS);
        if (MAXIMUM_SUPPORTED_JAVA_VERSION.equals(this.javaVersion)) {
            options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
        }
        JProblem.Type.compilerOptions().forEach(option -> options.put((String)option, "warning"));
        astParser.setCompilerOptions(options);
        boolean includeRunningVMBootclasspath = this.classpath.stream().noneMatch(f -> JRE_JARS.contains(f.getName()));
        astParser.setEnvironment((String[])this.classpath.stream().map(File::getAbsolutePath).toArray(String[]::new), new String[0], new String[0], includeRunningVMBootclasspath);
        astParser.setResolveBindings(true);
        astParser.setBindingsRecovery(true);
        return astParser;
    }

    public static String effectiveJavaVersion(@Nullable JavaVersion javaVersion) {
        if (javaVersion == null || javaVersion.isNotSet()) {
            return MAXIMUM_SUPPORTED_JAVA_VERSION;
        }
        return Integer.toString(javaVersion.asInt());
    }

    private static class FileByFile
    extends JParserConfig {
        private FileByFile(String javaVersion, List<File> classpath) {
            super(javaVersion, classpath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(Iterable<? extends InputFile> inputFiles, BooleanSupplier isCanceled, BiConsumer<InputFile, Result> action) {
            boolean successfullyCompleted = false;
            boolean cancelled = false;
            ExecutionTimeReport executionTimeReport = new ExecutionTimeReport();
            ProgressReport progressReport = new ProgressReport("Report about progress of Java AST analyzer", TimeUnit.SECONDS.toMillis(10L));
            List filesNames = StreamSupport.stream(inputFiles.spliterator(), false).map(InputFile::toString).collect(Collectors.toList());
            progressReport.start(filesNames);
            try {
                for (InputFile inputFile : inputFiles) {
                    Result result;
                    if (isCanceled.getAsBoolean()) {
                        cancelled = true;
                        break;
                    }
                    executionTimeReport.start(inputFile);
                    PerformanceMeasure.Duration parseDuration = PerformanceMeasure.start((String)"JParser");
                    try {
                        result = new Result(JParser.parse(this.astParser(), this.javaVersion, inputFile.filename(), inputFile.contents()));
                    }
                    catch (Exception e) {
                        result = new Result(e);
                    }
                    finally {
                        parseDuration.stop();
                    }
                    action.accept(inputFile, result);
                    executionTimeReport.end();
                    progressReport.nextFile();
                }
                successfullyCompleted = !cancelled;
            }
            finally {
                if (successfullyCompleted) {
                    progressReport.stop();
                } else {
                    progressReport.cancel();
                }
                executionTimeReport.report();
            }
        }
    }

    private static class Batch
    extends JParserConfig {
        private Batch(String javaVersion, List<File> classpath) {
            super(javaVersion, classpath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(Iterable<? extends InputFile> inputFiles, BooleanSupplier isCanceled, final BiConsumer<InputFile, Result> action) {
            LOG.info("Using ECJ batch to parse source files.");
            ArrayList<String> sourceFilePaths = new ArrayList<String>();
            ArrayList<String> encodings = new ArrayList<String>();
            final HashMap<File, InputFile> inputs = new HashMap<File, InputFile>();
            for (InputFile inputFile : inputFiles) {
                String sourceFilePath = inputFile.absolutePath();
                inputs.put(new File(sourceFilePath), inputFile);
                sourceFilePaths.add(sourceFilePath);
                encodings.add(inputFile.charset().name());
            }
            PerformanceMeasure.Duration batchPerformance = PerformanceMeasure.start((String)"ParseAsBatch");
            final ExecutionTimeReport executionTimeReport = new ExecutionTimeReport();
            ProgressMonitor monitor = new ProgressMonitor(isCanceled);
            try {
                this.astParser().createASTs(sourceFilePaths.toArray(new String[0]), encodings.toArray(new String[0]), new String[0], new FileASTRequestor(){

                    public void acceptAST(String sourceFilePath, CompilationUnit ast) {
                        Result result;
                        PerformanceMeasure.Duration convertDuration = PerformanceMeasure.start((String)"Convert");
                        InputFile inputFile = (InputFile)inputs.get(new File(sourceFilePath));
                        executionTimeReport.start(inputFile);
                        try {
                            result = new Result(JParser.convert(javaVersion, inputFile.filename(), inputFile.contents(), ast));
                        }
                        catch (Exception e) {
                            result = new Result(e);
                        }
                        convertDuration.stop();
                        PerformanceMeasure.Duration analyzeDuration = PerformanceMeasure.start((String)"Analyze");
                        action.accept(inputFile, result);
                        executionTimeReport.end();
                        analyzeDuration.stop();
                    }
                }, (IProgressMonitor)monitor);
            }
            finally {
                executionTimeReport.reportAsBatch();
                batchPerformance.stop();
                monitor.done();
            }
        }
    }

    public static class Result {
        private final Exception e;
        private final JavaTree.CompilationUnitTreeImpl t;

        private Result(Exception e) {
            this.e = e;
            this.t = null;
        }

        private Result(JavaTree.CompilationUnitTreeImpl t) {
            this.e = null;
            this.t = t;
        }

        public JavaTree.CompilationUnitTreeImpl get() throws Exception {
            if (this.e != null) {
                throw this.e;
            }
            return this.t;
        }
    }

    public static enum Mode {
        BATCH((x$0, x$1) -> new Batch((String)x$0, (List<File>)x$1)),
        FILE_BY_FILE((x$0, x$1) -> new FileByFile((String)x$0, (List<File>)x$1));

        private final BiFunction<String, List<File>, JParserConfig> supplier;

        private Mode(BiFunction<String, List<File>, JParserConfig> supplier) {
            this.supplier = supplier;
        }

        public JParserConfig create(String javaVersion, List<File> classpath) {
            return this.supplier.apply(javaVersion, classpath);
        }
    }
}

