/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.java.api.JavaVersion;

public class JavaVersionImpl
implements JavaVersion {
    private static final Logger LOG = LoggerFactory.getLogger(JavaVersionImpl.class);
    private static final int JAVA_6 = 6;
    private static final int JAVA_7 = 7;
    private static final int JAVA_8 = 8;
    private static final int JAVA_9 = 9;
    private static final int JAVA_10 = 10;
    private static final int JAVA_12 = 12;
    private static final int JAVA_14 = 14;
    private static final int JAVA_15 = 15;
    private static final int JAVA_16 = 16;
    private static final int JAVA_17 = 17;
    private static final int JAVA_18 = 18;
    private static final int JAVA_19 = 19;
    private static final int JAVA_20 = 21;
    private static final int JAVA_21 = 21;
    public static final int MAX_SUPPORTED = 21;
    private final int javaVersion;
    private final boolean previewFeaturesEnabled;

    public JavaVersionImpl() {
        this(-1, false);
    }

    public JavaVersionImpl(int javaVersion) {
        this(javaVersion, false);
    }

    public JavaVersionImpl(int javaVersion, boolean previewFeaturesEnabled) {
        this.javaVersion = javaVersion;
        this.previewFeaturesEnabled = previewFeaturesEnabled;
    }

    public static JavaVersion fromString(String javaVersion) {
        try {
            int versionAsInt = JavaVersionImpl.convertJavaVersionString(javaVersion);
            return new JavaVersionImpl(versionAsInt);
        }
        catch (NumberFormatException e) {
            LOG.warn("Invalid java version (got \"{}\"). The version will be ignored. Accepted formats are \"1.X\", or simply \"X\" (for instance: \"1.5\" or \"5\", \"1.6\" or \"6\", \"1.7\" or \"7\", etc.)", (Object)javaVersion);
            return new JavaVersionImpl();
        }
    }

    public static JavaVersion fromStrings(String javaVersion, String previewFeaturesFlag) {
        boolean previewFeaturesEnabled = JavaVersionImpl.convertBooleanString(previewFeaturesFlag);
        try {
            int versionAsInt = JavaVersionImpl.convertJavaVersionString(javaVersion);
            return new JavaVersionImpl(versionAsInt, previewFeaturesEnabled);
        }
        catch (NumberFormatException e) {
            LOG.warn("Invalid java version (got \"{}\"). The version will be ignored. Accepted formats are \"1.X\", or simply \"X\" (for instance: \"1.5\" or \"5\", \"1.6\" or \"6\", \"1.7\" or \"7\", etc.)", (Object)javaVersion);
            return new JavaVersionImpl();
        }
    }

    @Override
    public boolean isJava6Compatible() {
        return this.notSetOrAtLeast(6);
    }

    @Override
    public boolean isJava7Compatible() {
        return this.notSetOrAtLeast(7);
    }

    @Override
    public boolean isJava8Compatible() {
        return this.notSetOrAtLeast(8);
    }

    @Override
    public boolean isJava9Compatible() {
        return 9 <= this.javaVersion;
    }

    @Override
    public boolean isJava10Compatible() {
        return 10 <= this.javaVersion;
    }

    @Override
    public boolean isJava12Compatible() {
        return 12 <= this.javaVersion;
    }

    @Override
    public boolean isJava14Compatible() {
        return 14 <= this.javaVersion;
    }

    @Override
    public boolean isJava15Compatible() {
        return 15 <= this.javaVersion;
    }

    @Override
    public boolean isJava16Compatible() {
        return 16 <= this.javaVersion;
    }

    @Override
    public boolean isJava17Compatible() {
        return 17 <= this.javaVersion;
    }

    @Override
    public boolean isJava18Compatible() {
        return 18 <= this.javaVersion;
    }

    @Override
    public boolean isJava19Compatible() {
        return 19 <= this.javaVersion;
    }

    @Override
    public boolean isJava20Compatible() {
        return 21 <= this.javaVersion;
    }

    @Override
    public boolean isJava21Compatible() {
        return 21 <= this.javaVersion;
    }

    private boolean notSetOrAtLeast(int requiredJavaVersion) {
        return this.isNotSet() || requiredJavaVersion <= this.javaVersion;
    }

    @Override
    public String java6CompatibilityMessage() {
        return this.compatibilityMessage(6);
    }

    @Override
    public String java7CompatibilityMessage() {
        return this.compatibilityMessage(7);
    }

    @Override
    public String java8CompatibilityMessage() {
        return this.compatibilityMessage(8);
    }

    private String compatibilityMessage(int expected) {
        return this.isNotSet() ? " (sonar.java.source not set. Assuming " + expected + " or greater.)" : "";
    }

    @Override
    public int asInt() {
        return this.javaVersion;
    }

    @Override
    public boolean isSet() {
        return this.javaVersion != -1;
    }

    @Override
    public boolean isNotSet() {
        return this.javaVersion == -1;
    }

    @Override
    public String effectiveJavaVersionAsString() {
        if (this.isNotSet()) {
            return Integer.toString(21);
        }
        return Integer.toString(this.javaVersion);
    }

    public String toString() {
        return this.isNotSet() ? "none" : Integer.toString(this.javaVersion);
    }

    @Override
    public boolean arePreviewFeaturesEnabled() {
        return this.previewFeaturesEnabled;
    }

    private static boolean convertBooleanString(String booleanString) {
        return Boolean.parseBoolean(booleanString.trim().toLowerCase(Locale.ROOT));
    }

    private static int convertJavaVersionString(String javaVersion) {
        String cleanedVersion = javaVersion.startsWith("1.") ? javaVersion.substring(2) : javaVersion;
        return Integer.parseInt(cleanedVersion);
    }
}

