/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.check.Rule;
import org.sonar.java.AnalysisException;
import org.sonar.java.CheckFailureException;
import org.sonar.java.ExceptionHandler;
import org.sonar.java.IllegalRuleParameterException;
import org.sonar.java.SonarComponents;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.ast.visitors.SonarSymbolTableVisitor;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.caching.CacheContextImpl;
import org.sonar.java.exceptions.ApiMismatchException;
import org.sonar.java.exceptions.ThrowableUtils;
import org.sonar.java.model.DefaultInputFileScannerContext;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.model.DefaultModuleScannerContext;
import org.sonar.java.model.GeneratedFile;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.JavaVersionImpl;
import org.sonar.plugins.java.api.InputFileScannerContext;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.ModuleScannerContext;
import org.sonar.plugins.java.api.caching.CacheContext;
import org.sonar.plugins.java.api.internal.EndOfAnalysis;
import org.sonar.plugins.java.api.semantic.Sema;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ImportClauseTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.performance.measure.PerformanceMeasure;

public class VisitorsBridge {
    private static final Logger LOG = LoggerFactory.getLogger(VisitorsBridge.class);
    private final Iterable<? extends JavaCheck> visitors;
    private final List<JavaFileScanner> allScanners;
    private final List<JavaFileScanner> scannersThatCannotBeSkipped;
    private final SonarComponents sonarComponents;
    protected InputFile currentFile;
    protected final JavaVersion javaVersion;
    private final List<File> classpath;
    protected boolean inAndroidContext = false;
    private int fullyScannedFileCount = 0;
    private int skippedFileCount = 0;
    @VisibleForTesting
    CacheContext cacheContext;

    @VisibleForTesting
    public VisitorsBridge(JavaFileScanner visitor) {
        this(Collections.singletonList(visitor), new ArrayList<File>(), null, new JavaVersionImpl());
    }

    @VisibleForTesting
    public VisitorsBridge(Iterable<? extends JavaCheck> visitors, List<File> projectClasspath, @Nullable SonarComponents sonarComponents) {
        this(visitors, projectClasspath, sonarComponents, new JavaVersionImpl());
    }

    public VisitorsBridge(Iterable<? extends JavaCheck> visitors, List<File> projectClasspath, @Nullable SonarComponents sonarComponents, JavaVersion javaVersion) {
        this.visitors = visitors;
        this.allScanners = new ArrayList<JavaFileScanner>();
        this.scannersThatCannotBeSkipped = new ArrayList<JavaFileScanner>();
        this.classpath = projectClasspath;
        this.sonarComponents = sonarComponents;
        this.cacheContext = CacheContextImpl.of(sonarComponents);
        this.javaVersion = javaVersion;
        this.updateScanners();
    }

    private void updateScanners() {
        this.allScanners.clear();
        this.scannersThatCannotBeSkipped.clear();
        this.allScanners.addAll(this.filterVisitors(this.visitors, this::isVisitorJavaVersionCompatible));
        if (this.canSkipScanningOfUnchangedFiles()) {
            this.scannersThatCannotBeSkipped.addAll(this.filterVisitors(this.visitors, this::isUnskippableVisitor));
        }
    }

    private List<JavaFileScanner> filterVisitors(Iterable<? extends JavaCheck> visitors, Predicate<Object> predicate) {
        ArrayList<JavaFileScanner> scanners = new ArrayList<JavaFileScanner>();
        IssuableSubscriptionVisitorsRunner runner = new IssuableSubscriptionVisitorsRunner();
        StreamSupport.stream(visitors.spliterator(), false).filter(predicate).forEach(visitor -> {
            if (visitor instanceof IssuableSubscriptionVisitor) {
                IssuableSubscriptionVisitor issuableSubscriptionVisitor = (IssuableSubscriptionVisitor)visitor;
                runner.add(issuableSubscriptionVisitor);
            } else if (visitor instanceof JavaFileScanner) {
                JavaFileScanner javaFileScanner = (JavaFileScanner)visitor;
                scanners.add(javaFileScanner);
            }
        });
        if (!runner.subscriptionVisitors.isEmpty()) {
            scanners.add(runner);
        }
        return scanners;
    }

    boolean canSkipScanningOfUnchangedFiles() {
        try {
            return this.sonarComponents != null && this.sonarComponents.canSkipUnchangedFiles();
        }
        catch (ApiMismatchException ignored) {
            return false;
        }
    }

    boolean isUnskippableVisitor(Object visitor) {
        return this.isVisitorJavaVersionCompatible(visitor) && !VisitorsBridge.canVisitorBeSkippedOnUnchangedFiles(visitor);
    }

    boolean isVisitorJavaVersionCompatible(Object visitor) {
        JavaVersionAwareVisitor javaVersionAwareVisitor;
        return !(visitor instanceof JavaVersionAwareVisitor) || (javaVersionAwareVisitor = (JavaVersionAwareVisitor)visitor).isCompatibleWithJavaVersion(this.javaVersion);
    }

    static boolean canVisitorBeSkippedOnUnchangedFiles(Object visitor) {
        return !(visitor instanceof EndOfAnalysis) && visitor.getClass().getCanonicalName().startsWith("org.sonar.java.checks.");
    }

    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    public List<File> getClasspath() {
        return this.classpath;
    }

    public void setInAndroidContext(boolean inAndroidContext) {
        this.inAndroidContext = inAndroidContext;
    }

    public void setCacheContext(CacheContext cacheContext) {
        this.cacheContext = cacheContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scanWithoutParsing(InputFile inputFile) {
        if (this.sonarComponents != null && this.sonarComponents.fileCanBeSkipped(inputFile)) {
            PerformanceMeasure.Duration duration = PerformanceMeasure.start((String)"ScanWithoutParsing");
            boolean allScansSucceeded = true;
            InputFileScannerContext fileScannerContext = this.createScannerContext(this.sonarComponents, inputFile, this.javaVersion, this.inAndroidContext, this.cacheContext);
            for (JavaFileScanner scanner : this.scannersThatCannotBeSkipped) {
                boolean exceptionIsBlownUp = false;
                PerformanceMeasure.Duration scannerDuration = PerformanceMeasure.start((Object)scanner);
                try {
                    allScansSucceeded &= scanner.scanWithoutParsing(fileScannerContext);
                }
                catch (AnalysisException e) {
                    throw e;
                }
                catch (Exception e) {
                    exceptionIsBlownUp = true;
                    allScansSucceeded = false;
                    String failureMessage = String.format("Scan without parsing of file %s failed for scanner %s.", inputFile, scanner.getClass().getCanonicalName());
                    LOG.warn(failureMessage);
                    this.interruptIfFailFast(new CheckFailureException(failureMessage, e));
                    exceptionIsBlownUp = false;
                }
                finally {
                    scannerDuration.stop();
                    if (!exceptionIsBlownUp) continue;
                    duration.stop();
                }
            }
            duration.stop();
            return allScansSucceeded;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitFile(@Nullable Tree parsedTree, boolean fileCanBeSkipped) {
        boolean fileParsed;
        if (fileCanBeSkipped) {
            ++this.skippedFileCount;
        } else {
            ++this.fullyScannedFileCount;
        }
        PerformanceMeasure.Duration compilationUnitDuration = PerformanceMeasure.start((String)"CompilationUnit");
        JavaTree.CompilationUnitTreeImpl tree = new JavaTree.CompilationUnitTreeImpl(null, new ArrayList<ImportClauseTree>(), new ArrayList<Tree>(), null, null);
        compilationUnitDuration.stop();
        PerformanceMeasure.Duration symbolTableDuration = PerformanceMeasure.start((String)"SymbolTable");
        boolean bl = fileParsed = parsedTree != null;
        if (fileParsed && parsedTree.is(Tree.Kind.COMPILATION_UNIT)) {
            tree = (JavaTree.CompilationUnitTreeImpl)parsedTree;
            this.createSonarSymbolTable(tree);
        }
        symbolTableDuration.stop();
        JavaFileScannerContext javaFileScannerContext = this.createScannerContext(tree, tree.sema, this.sonarComponents, fileParsed);
        List<JavaFileScanner> scanners = this.getScanners(fileCanBeSkipped);
        PerformanceMeasure.Duration scannersDuration = PerformanceMeasure.start((String)"Scanners");
        for (JavaFileScanner scanner : scanners) {
            PerformanceMeasure.Duration scannerDuration = PerformanceMeasure.start((Object)scanner);
            try {
                this.runScanner(javaFileScannerContext, scanner);
            }
            catch (CheckFailureException e) {
                this.interruptIfFailFast(e);
            }
            finally {
                scannerDuration.stop();
            }
        }
        scannersDuration.stop();
    }

    private void interruptIfFailFast(CheckFailureException e) {
        if (this.sonarComponents != null && this.sonarComponents.shouldFailAnalysisOnException()) {
            throw new AnalysisException("Failing check", e);
        }
    }

    private void runScanner(JavaFileScannerContext javaFileScannerContext, JavaFileScanner scanner) throws CheckFailureException {
        this.runScanner(() -> scanner.scanFile(javaFileScannerContext), scanner);
    }

    private void runScanner(Runnable action, JavaFileScanner scanner) throws CheckFailureException {
        try {
            action.run();
        }
        catch (IllegalRuleParameterException e) {
            throw new AnalysisException("Bad configuration of rule parameter", e);
        }
        catch (Exception e) {
            Throwable rootCause = ThrowableUtils.getRootCause(e);
            if (rootCause instanceof InterruptedIOException || rootCause instanceof InterruptedException || rootCause instanceof CancellationException || this.analysisCancelled()) {
                throw e;
            }
            String message = String.format("Unable to run check %s - %s on file '%s', To help improve the SonarSource Java Analyzer, please report this problem to SonarSource: see https://community.sonarsource.com/", scanner.getClass(), VisitorsBridge.ruleKey(scanner), this.currentFile);
            LOG.error(message, (Throwable)e);
            throw new CheckFailureException(message, e);
        }
    }

    private boolean analysisCancelled() {
        return this.sonarComponents != null && this.sonarComponents.analysisCancelled();
    }

    private static String ruleKey(JavaFileScanner scanner) {
        Rule annotation = (Rule)AnnotationUtils.getAnnotation(scanner.getClass(), Rule.class);
        if (annotation != null) {
            return annotation.key();
        }
        return "";
    }

    protected InputFileScannerContext createScannerContext(SonarComponents sonarComponents, InputFile inputFile, JavaVersion javaVersion, boolean inAndroidContext, CacheContext cacheContext) {
        return new DefaultInputFileScannerContext(sonarComponents, inputFile, javaVersion, inAndroidContext, cacheContext);
    }

    protected JavaFileScannerContext createScannerContext(CompilationUnitTree tree, @Nullable Sema semanticModel, SonarComponents sonarComponents, boolean fileParsed) {
        return new DefaultJavaFileScannerContext(tree, this.currentFile, semanticModel, sonarComponents, this.javaVersion, fileParsed, this.inAndroidContext, this.cacheContext);
    }

    protected ModuleScannerContext createScannerContext(@Nullable SonarComponents sonarComponents, JavaVersion javaVersion, boolean inAndroidContext, @Nullable CacheContext cacheContext) {
        return new DefaultModuleScannerContext(sonarComponents, javaVersion, inAndroidContext, cacheContext);
    }

    private void createSonarSymbolTable(CompilationUnitTree tree) {
        if (this.sonarComponents != null && !this.sonarComponents.isSonarLintContext() && !(this.currentFile instanceof GeneratedFile)) {
            SonarSymbolTableVisitor symVisitor = new SonarSymbolTableVisitor(this.sonarComponents.symbolizableFor(this.currentFile));
            symVisitor.visitCompilationUnit(tree);
        }
    }

    private List<JavaFileScanner> getScanners(boolean supportedScannersCanBeSkippedForThisFile) {
        return supportedScannersCanBeSkippedForThisFile ? this.scannersThatCannotBeSkipped : this.allScanners;
    }

    public void processRecognitionException(RecognitionException e, InputFile inputFile) {
        if (this.sonarComponents == null || !this.sonarComponents.reportAnalysisError(e, inputFile)) {
            this.visitFile(null, false);
            this.getScanners(false).stream().filter(ExceptionHandler.class::isInstance).forEach(scanner -> ((ExceptionHandler)((Object)scanner)).processRecognitionException(e));
        }
    }

    public void setCurrentFile(InputFile inputFile) {
        this.currentFile = inputFile;
    }

    public void endOfAnalysis() {
        if (this.skippedFileCount > 0) {
            LOG.info("Optimized analysis for {} of {} files.", (Object)this.skippedFileCount, (Object)(this.skippedFileCount + this.fullyScannedFileCount));
        } else if (this.fullyScannedFileCount > 0) {
            LOG.info("Did not optimize analysis for any files, performed a full analysis for all {} files.", (Object)this.fullyScannedFileCount);
        }
        ModuleScannerContext moduleContext = this.createScannerContext(this.sonarComponents, this.javaVersion, this.inAndroidContext, this.cacheContext);
        this.allScanners.stream().filter(EndOfAnalysis.class::isInstance).map(EndOfAnalysis.class::cast).forEach(check -> check.endOfAnalysis(moduleContext));
    }

    private class IssuableSubscriptionVisitorsRunner
    implements JavaFileScanner,
    EndOfAnalysis {
        private EnumMap<Tree.Kind, List<SubscriptionVisitor>> checks = new EnumMap(Tree.Kind.class);
        private List<SubscriptionVisitor> subscriptionVisitors = new ArrayList<SubscriptionVisitor>();

        IssuableSubscriptionVisitorsRunner() {
        }

        private void add(SubscriptionVisitor subscriptionVisitor) {
            this.subscriptionVisitors.add(subscriptionVisitor);
            subscriptionVisitor.nodesToVisit().forEach(k -> this.checks.computeIfAbsent((Tree.Kind)((Object)k), key -> new ArrayList()).add(subscriptionVisitor));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean scanWithoutParsing(InputFileScannerContext fileScannerContext) throws AnalysisException {
            boolean allScansSucceeded = true;
            for (SubscriptionVisitor visitor : this.subscriptionVisitors) {
                PerformanceMeasure.Duration duration = PerformanceMeasure.start((Object)visitor);
                try {
                    allScansSucceeded &= visitor.scanWithoutParsing(fileScannerContext);
                }
                catch (Exception e) {
                    allScansSucceeded = false;
                    String failureMessage = String.format("Scan without parsing of file %s failed for scanner %s.", fileScannerContext.getInputFile(), visitor.getClass().getCanonicalName());
                    LOG.warn(failureMessage);
                    VisitorsBridge.this.interruptIfFailFast(new CheckFailureException(failureMessage, e));
                }
                finally {
                    duration.stop();
                }
            }
            return allScansSucceeded;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scanFile(JavaFileScannerContext javaFileScannerContext) {
            PerformanceMeasure.Duration issuableSubscriptionVisitorsDuration = PerformanceMeasure.start((String)"IssuableSubscriptionVisitors");
            try {
                this.forEach(this.subscriptionVisitors, s -> s.setContext(javaFileScannerContext));
                this.visit(javaFileScannerContext.getTree());
                this.forEach(this.subscriptionVisitors, s -> s.leaveFile(javaFileScannerContext));
            }
            catch (CheckFailureException e) {
                VisitorsBridge.this.interruptIfFailFast(e);
            }
            finally {
                issuableSubscriptionVisitorsDuration.stop();
            }
        }

        @Override
        public void endOfAnalysis(ModuleScannerContext cachedContext) {
            this.subscriptionVisitors.stream().filter(EndOfAnalysis.class::isInstance).map(EndOfAnalysis.class::cast).forEach(check -> check.endOfAnalysis(cachedContext));
        }

        private void visitChildren(Tree tree) throws CheckFailureException {
            JavaTree javaTree = (JavaTree)tree;
            if (!javaTree.isLeaf()) {
                for (Tree next : javaTree.getChildren()) {
                    if (next == null) continue;
                    this.visit(next);
                }
            }
        }

        private void visit(Tree tree) throws CheckFailureException {
            Tree.Kind kind = tree.kind();
            List<SubscriptionVisitor> subscribed = this.checks.getOrDefault((Object)kind, Collections.emptyList());
            boolean isToken = kind == Tree.Kind.TOKEN;
            Consumer<SubscriptionVisitor> callback = isToken ? s -> s.visitToken((SyntaxToken)tree) : s -> s.visitNode(tree);
            this.forEach(subscribed, callback);
            if (isToken) {
                this.forEach(this.checks.getOrDefault((Object)Tree.Kind.TRIVIA, Collections.emptyList()), s -> ((SyntaxToken)tree).trivias().forEach(s::visitTrivia));
            } else {
                this.visitChildren(tree);
            }
            if (!isToken) {
                this.forEach(subscribed, s -> s.leaveNode(tree));
            }
        }

        private final void forEach(Collection<SubscriptionVisitor> visitors, Consumer<SubscriptionVisitor> callback) throws CheckFailureException {
            for (SubscriptionVisitor visitor : visitors) {
                PerformanceMeasure.Duration visitorDuration = PerformanceMeasure.start((Object)visitor);
                VisitorsBridge.this.runScanner(() -> callback.accept(visitor), (JavaFileScanner)visitor);
                visitorDuration.stop();
            }
        }
    }
}

