/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.model.LineUtils;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;

public class CommentLinesVisitor
extends SubscriptionVisitor {
    private Set<Integer> comments = new HashSet<Integer>();
    private Set<Integer> noSonarLines = new HashSet<Integer>();
    private Map<Path, Set<SyntaxTrivia>> syntaxTrivia = new HashMap<Path, Set<SyntaxTrivia>>();
    private boolean seenFirstToken;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.TOKEN);
    }

    public void analyzeCommentLines(CompilationUnitTree tree) {
        this.comments.clear();
        this.noSonarLines.clear();
        this.syntaxTrivia.clear();
        this.seenFirstToken = false;
        this.scanTree(tree);
    }

    @Override
    public void visitToken(SyntaxToken syntaxToken) {
        for (SyntaxTrivia trivia : syntaxToken.trivias()) {
            if (this.seenFirstToken) {
                this.handleCommentsForTrivia(trivia);
                continue;
            }
            this.seenFirstToken = true;
        }
        this.seenFirstToken = true;
    }

    private void handleCommentsForTrivia(SyntaxTrivia trivia) {
        String[] commentLines = CommentLinesVisitor.getContents(trivia.comment()).split("(\r)?\n|\r", -1);
        int line = LineUtils.startLine(trivia);
        for (String commentLine : commentLines) {
            if (commentLine.contains("NOSONAR")) {
                this.noSonarLines.add(line);
            } else if (!CommentLinesVisitor.isBlank(commentLine)) {
                Path path = Path.of("", new String[0]);
                if (this.context != null) {
                    path = Paths.get(this.context.getInputFile().uri());
                }
                this.syntaxTrivia.computeIfAbsent(path, k -> new HashSet()).add(trivia);
                this.comments.add(line);
            }
            ++line;
        }
    }

    public Map<Path, Set<SyntaxTrivia>> getSyntaxTrivia() {
        return this.syntaxTrivia;
    }

    public Set<Integer> noSonarLines() {
        return this.noSonarLines;
    }

    public int commentLinesMetric() {
        return this.comments.size();
    }

    private static boolean isBlank(String line) {
        for (int i = 0; i < line.length(); ++i) {
            char character = line.charAt(i);
            if (Character.isWhitespace(character) || character == '*' || character == '/') continue;
            return false;
        }
        return true;
    }

    private static String getContents(String comment) {
        return comment.startsWith("//") ? comment.substring(2) : comment.substring(2, comment.length() - 2);
    }
}

