/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.cfg.CFG;
import org.sonar.java.model.LineUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class FileLinesVisitor
extends SubscriptionVisitor {
    private final SonarComponents sonarComponents;
    private final Set<Integer> linesOfCode = new HashSet<Integer>();
    private final Set<Integer> executableLines = new HashSet<Integer>();

    public FileLinesVisitor(SonarComponents sonarComponents) {
        this.sonarComponents = sonarComponents;
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.TOKEN, Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR, Tree.Kind.INITIALIZER, Tree.Kind.STATIC_INITIALIZER, Tree.Kind.VARIABLE, Tree.Kind.FOR_EACH_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_STATEMENT, Tree.Kind.LAMBDA_EXPRESSION);
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        super.scanFile(context);
        InputFile currentFile = context.getInputFile();
        FileLinesContext fileLinesContext = this.sonarComponents.fileLinesContextFor(currentFile);
        for (int line = 1; line <= currentFile.lines(); ++line) {
            fileLinesContext.setIntValue("ncloc_data", line, this.linesOfCode.contains(line) ? 1 : 0);
            fileLinesContext.setIntValue("executable_lines_data", line, this.executableLines.contains(line) ? 1 : 0);
        }
        fileLinesContext.save();
        this.linesOfCode.clear();
        this.executableLines.clear();
    }

    @Override
    public void visitNode(Tree tree) {
        List<Object> trees = Collections.emptyList();
        switch (tree.kind()) {
            case INITIALIZER: 
            case STATIC_INITIALIZER: {
                trees = ((BlockTree)tree).body();
                break;
            }
            case VARIABLE: {
                trees = this.visitVariable((VariableTree)tree);
                break;
            }
            case LAMBDA_EXPRESSION: {
                trees = FileLinesVisitor.visitLambda((LambdaExpressionTree)tree);
                break;
            }
            case METHOD: 
            case CONSTRUCTOR: {
                trees = this.visitMethod((MethodTree)tree);
                break;
            }
            case FOR_STATEMENT: 
            case FOR_EACH_STATEMENT: 
            case WHILE_STATEMENT: 
            case DO_STATEMENT: {
                this.executableLines.add(LineUtils.startLine(tree.lastToken()));
                break;
            }
        }
        this.computeExecutableLines(trees);
    }

    private List<? extends Tree> visitVariable(VariableTree variableTree) {
        ExpressionTree initializer = variableTree.initializer();
        if (initializer != null && !FileLinesVisitor.isConstant(variableTree)) {
            return Collections.singletonList(initializer);
        }
        if (variableTree.parent().is(Tree.Kind.CATCH)) {
            new ExecutableLinesTokenVisitor().scanTree(variableTree);
        }
        return Collections.emptyList();
    }

    private static List<? extends Tree> visitLambda(LambdaExpressionTree lambda) {
        Tree body = lambda.body();
        if (body.is(Tree.Kind.BLOCK)) {
            return ((BlockTree)body).body();
        }
        return Collections.singletonList(body);
    }

    private List<? extends Tree> visitMethod(MethodTree tree) {
        BlockTree methodBody = tree.block();
        if (methodBody != null) {
            TypeTree returnType = tree.returnType();
            if (returnType == null || "void".equals(returnType.firstToken().text())) {
                this.executableLines.add(LineUtils.startLine(methodBody.closeBraceToken()));
            }
            return methodBody.body();
        }
        return Collections.emptyList();
    }

    private void computeExecutableLines(List<? extends Tree> trees) {
        if (trees.isEmpty()) {
            return;
        }
        CFG cfg = CFG.buildCFG(trees);
        cfg.blocks().stream().flatMap(b -> b.elements().stream()).forEach(t -> {
            if (t.is(Tree.Kind.NEW_CLASS)) {
                NewClassTree newClassTree = (NewClassTree)t;
                new ExecutableLinesTokenVisitor().scanTree(newClassTree.identifier());
                this.executableLines.add(LineUtils.startLine(newClassTree.newKeyword()));
            } else if (t.is(Tree.Kind.TRY_STATEMENT)) {
                this.executableLines.add(LineUtils.startLine(t.lastToken()));
            } else {
                this.executableLines.add(LineUtils.startLine(t));
            }
        });
    }

    @Override
    public void visitToken(SyntaxToken syntaxToken) {
        this.linesOfCode.add(LineUtils.startLine(syntaxToken));
    }

    private static boolean isConstant(VariableTree variableTree) {
        return ModifiersUtils.hasAll(variableTree.modifiers(), Modifier.STATIC, Modifier.FINAL) && variableTree.initializer().is(Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.STRING_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.CHAR_LITERAL, Tree.Kind.INT_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.NULL_LITERAL);
    }

    private class ExecutableLinesTokenVisitor
    extends SubscriptionVisitor {
        private ExecutableLinesTokenVisitor() {
        }

        @Override
        public List<Tree.Kind> nodesToVisit() {
            return Collections.singletonList(Tree.Kind.TOKEN);
        }

        @Override
        public void visitToken(SyntaxToken syntaxToken) {
            FileLinesVisitor.this.executableLines.add(LineUtils.startLine(syntaxToken));
        }
    }
}

