/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.lang.invoke.LambdaMetafactory;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public final class ExpressionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExpressionUtils.class);

    private ExpressionUtils() {
    }

    public static boolean isSimpleAssignment(AssignmentExpressionTree tree) {
        if (!tree.is(Tree.Kind.ASSIGNMENT)) {
            return false;
        }
        ExpressionTree variable = ExpressionUtils.skipParentheses(tree.variable());
        return variable.is(Tree.Kind.IDENTIFIER) || ExpressionUtils.isSelectOnThisOrSuper(tree);
    }

    public static boolean isSelectOnThisOrSuper(AssignmentExpressionTree tree) {
        ExpressionTree variable = ExpressionUtils.skipParentheses(tree.variable());
        return variable.is(Tree.Kind.MEMBER_SELECT) && ExpressionUtils.isSelectOnThisOrSuper((MemberSelectExpressionTree)variable);
    }

    public static boolean isSelectOnThisOrSuper(MemberSelectExpressionTree tree) {
        if (!tree.expression().is(Tree.Kind.IDENTIFIER)) {
            return false;
        }
        String selectSourceName = ((IdentifierTree)tree.expression()).name();
        return "this".equalsIgnoreCase(selectSourceName) || "super".equalsIgnoreCase(selectSourceName);
    }

    public static IdentifierTree extractIdentifier(AssignmentExpressionTree tree) {
        Optional<IdentifierTree> identifier = ExpressionUtils.extractIdentifier(tree.variable());
        if (identifier.isPresent()) {
            return identifier.get();
        }
        throw new IllegalArgumentException("Can not extract identifier.");
    }

    private static Optional<IdentifierTree> extractIdentifier(ExpressionTree tree) {
        MemberSelectExpressionTree selectTree;
        ExpressionTree cleanedExpression = ExpressionUtils.skipParentheses(tree);
        if (cleanedExpression.is(Tree.Kind.IDENTIFIER)) {
            return Optional.of((IdentifierTree)cleanedExpression);
        }
        if (cleanedExpression.is(Tree.Kind.MEMBER_SELECT) && ExpressionUtils.isSelectOnThisOrSuper(selectTree = (MemberSelectExpressionTree)cleanedExpression)) {
            return Optional.of(selectTree.identifier());
        }
        return Optional.empty();
    }

    public static Optional<Symbol> extractIdentifierSymbol(ExpressionTree tree) {
        return ExpressionUtils.extractIdentifier(tree).map(IdentifierTree::symbol);
    }

    public static boolean isInvocationOnVariable(MethodInvocationTree mit, @Nullable Symbol variable, boolean defaultReturn) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (variable == null || !methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
            return defaultReturn;
        }
        return ExpressionUtils.extractIdentifierSymbol(((MemberSelectExpressionTree)methodSelect).expression()).map((Function<Symbol, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, equals(java.lang.Object ), (Lorg/sonar/plugins/java/api/semantic/Symbol;)Ljava/lang/Boolean;)((Symbol)variable)).orElse(defaultReturn);
    }

    public static ExpressionTree skipParentheses(ExpressionTree tree) {
        ExpressionTree result = tree;
        while (result.is(Tree.Kind.PARENTHESIZED_EXPRESSION)) {
            result = ((ParenthesizedTree)result).expression();
        }
        return result;
    }

    public static boolean isNullLiteral(ExpressionTree tree) {
        return ExpressionUtils.skipParentheses(tree).is(Tree.Kind.NULL_LITERAL);
    }

    public static boolean isSecuringByte(ExpressionTree expression) {
        if (expression.is(Tree.Kind.AND)) {
            BinaryExpressionTree and = (BinaryExpressionTree)expression;
            return LiteralUtils.is0xff(and.rightOperand()) || LiteralUtils.is0xff(and.leftOperand());
        }
        return false;
    }

    public static IdentifierTree methodName(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        IdentifierTree id = methodSelect.is(Tree.Kind.IDENTIFIER) ? (IdentifierTree)methodSelect : ((MemberSelectExpressionTree)methodSelect).identifier();
        return id;
    }

    @CheckForNull
    public static MethodTree getEnclosingMethod(ExpressionTree expr) {
        return (MethodTree)ExpressionUtils.getEnclosingTree(expr, Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR);
    }

    @CheckForNull
    public static Tree getEnclosingTree(Tree expr, Tree.Kind ... kinds) {
        Tree result;
        for (result = expr.parent(); result != null && !result.is(kinds); result = result.parent()) {
        }
        return result;
    }

    @Nullable
    public static Tree getParentOfType(Tree tree, Tree.Kind ... kinds) {
        Tree result;
        for (result = tree.parent(); result != null && !result.is(kinds); result = result.parent()) {
        }
        return result;
    }

    public static Optional<Symbol> getAssignedSymbol(ExpressionTree exp) {
        Tree parent = exp.parent();
        if (parent != null) {
            if (parent.is(Tree.Kind.ASSIGNMENT)) {
                return ExpressionUtils.extractIdentifierSymbol(((AssignmentExpressionTree)parent).variable());
            }
            if (parent.is(Tree.Kind.VARIABLE)) {
                return Optional.of(((VariableTree)parent).simpleName().symbol());
            }
        }
        return Optional.empty();
    }

    public static boolean isThis(ExpressionTree expression) {
        ExpressionTree newExpression = ExpressionUtils.skipParentheses(expression);
        return newExpression.is(Tree.Kind.IDENTIFIER) && "this".equals(((IdentifierTree)newExpression).name());
    }

    @CheckForNull
    public static Object resolveAsConstant(ExpressionTree tree) {
        ExpressionTree expression = tree;
        while (expression.is(Tree.Kind.PARENTHESIZED_EXPRESSION)) {
            expression = ((ParenthesizedTree)expression).expression();
        }
        if (expression.is(Tree.Kind.MEMBER_SELECT)) {
            expression = ((MemberSelectExpressionTree)expression).identifier();
        }
        if (expression.is(Tree.Kind.IDENTIFIER)) {
            return ExpressionUtils.resolveIdentifier((IdentifierTree)expression);
        }
        if (expression.is(Tree.Kind.BOOLEAN_LITERAL)) {
            return Boolean.parseBoolean(((LiteralTree)expression).value());
        }
        if (expression.is(Tree.Kind.STRING_LITERAL, Tree.Kind.TEXT_BLOCK)) {
            return LiteralUtils.getAsStringValue((LiteralTree)expression);
        }
        if (expression instanceof UnaryExpressionTree) {
            UnaryExpressionTree unaryExpressionTree = (UnaryExpressionTree)expression;
            return ExpressionUtils.resolveUnaryExpression(unaryExpressionTree);
        }
        if (expression.is(Tree.Kind.INT_LITERAL)) {
            return LiteralUtils.intLiteralValue(expression);
        }
        if (expression.is(Tree.Kind.LONG_LITERAL)) {
            return LiteralUtils.longLiteralValue(expression);
        }
        if (expression.is(Tree.Kind.PLUS)) {
            return ExpressionUtils.resolvePlus((BinaryExpressionTree)expression);
        }
        if (expression.is(Tree.Kind.OR)) {
            return ExpressionUtils.resolveOr((BinaryExpressionTree)expression);
        }
        if (expression.is(Tree.Kind.MINUS)) {
            return ExpressionUtils.resolveArithmeticOperation((BinaryExpressionTree)expression, (a, b) -> a - b, (a, b) -> a - b);
        }
        if (expression.is(Tree.Kind.MULTIPLY)) {
            return ExpressionUtils.resolveArithmeticOperation((BinaryExpressionTree)expression, (a, b) -> a * b, (a, b) -> a * b);
        }
        if (expression.is(Tree.Kind.DIVIDE)) {
            return ExpressionUtils.resolveArithmeticOperation((BinaryExpressionTree)expression, (a, b) -> a / b, (a, b) -> a / b);
        }
        if (expression.is(Tree.Kind.REMAINDER)) {
            return ExpressionUtils.resolveArithmeticOperation((BinaryExpressionTree)expression, (a, b) -> a % b, (a, b) -> a % b);
        }
        return null;
    }

    public static boolean areVariablesSame(Tree tree1, Tree tree2, boolean defaultValue) {
        Symbol symbol1 = ExpressionUtils.getSymbol(tree1);
        Symbol symbol2 = ExpressionUtils.getSymbol(tree2);
        if (symbol1 == null || symbol1.isUnknown() || symbol2 == null || symbol2.isUnknown()) {
            return defaultValue;
        }
        return symbol1.name().equals(symbol2.name());
    }

    @CheckForNull
    private static Symbol getSymbol(Tree tree) {
        Symbol symbol = null;
        if (tree.is(Tree.Kind.IDENTIFIER)) {
            symbol = ((IdentifierTree)tree).symbol();
        } else if (tree.is(Tree.Kind.MEMBER_SELECT)) {
            symbol = ((MemberSelectExpressionTree)tree).identifier().symbol();
        }
        return symbol;
    }

    @CheckForNull
    private static Object resolveUnaryExpression(UnaryExpressionTree unaryExpression) {
        Object value = ExpressionUtils.resolveAsConstant(unaryExpression.expression());
        if (unaryExpression.is(Tree.Kind.UNARY_PLUS)) {
            return value;
        }
        if (unaryExpression.is(Tree.Kind.UNARY_MINUS)) {
            if (value instanceof Long) {
                Long longValue = (Long)value;
                return -longValue.longValue();
            }
            if (value instanceof Integer) {
                Integer intValue = (Integer)value;
                return -intValue.intValue();
            }
        } else if (unaryExpression.is(Tree.Kind.BITWISE_COMPLEMENT)) {
            if (value instanceof Long) {
                Long longValue = (Long)value;
                return longValue ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (value instanceof Integer) {
                Integer intValue = (Integer)value;
                return ~intValue.intValue();
            }
        } else if (unaryExpression.is(Tree.Kind.LOGICAL_COMPLEMENT) && value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return bool == false;
        }
        return null;
    }

    @CheckForNull
    private static Object resolveIdentifier(IdentifierTree tree) {
        Symbol symbol = tree.symbol();
        if (!symbol.isVariableSymbol()) {
            return null;
        }
        Symbol owner = symbol.owner();
        if (owner.isTypeSymbol() && owner.type().is("java.lang.Boolean")) {
            if ("TRUE".equals(symbol.name())) {
                return Boolean.TRUE;
            }
            if ("FALSE".equals(symbol.name())) {
                return Boolean.FALSE;
            }
        }
        return ((Symbol.VariableSymbol)symbol).constantValue().orElse(null);
    }

    @CheckForNull
    private static Object resolvePlus(BinaryExpressionTree binaryExpression) {
        Object left = ExpressionUtils.resolveAsConstant(binaryExpression.leftOperand());
        Object right = ExpressionUtils.resolveAsConstant(binaryExpression.rightOperand());
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof String) {
            String leftString = (String)left;
            return leftString + String.valueOf(right);
        }
        if (right instanceof String) {
            String rightString = (String)right;
            return String.valueOf(left) + rightString;
        }
        return ExpressionUtils.resolveArithmeticOperation(left, right, Long::sum, Integer::sum);
    }

    @CheckForNull
    private static Object resolveArithmeticOperation(BinaryExpressionTree binaryExpression, BiFunction<Long, Long, Object> longOperation, BiFunction<Integer, Integer, Object> intOperation) {
        Object left = ExpressionUtils.resolveAsConstant(binaryExpression.leftOperand());
        Object right = ExpressionUtils.resolveAsConstant(binaryExpression.rightOperand());
        if (left == null || right == null) {
            return null;
        }
        return ExpressionUtils.resolveArithmeticOperation(left, right, longOperation, intOperation);
    }

    @CheckForNull
    private static Object resolveArithmeticOperation(Object left, Object right, BiFunction<Long, Long, Object> longOperation, BiFunction<Integer, Integer, Object> intOperation) {
        try {
            if (left instanceof Integer) {
                Integer leftInt = (Integer)left;
                if (right instanceof Integer) {
                    Integer rightInt = (Integer)right;
                    return intOperation.apply(leftInt, rightInt);
                }
            }
            if ((left instanceof Long || right instanceof Long) && (left instanceof Integer || right instanceof Integer)) {
                return longOperation.apply(((Number)left).longValue(), ((Number)right).longValue());
            }
        }
        catch (ArithmeticException e) {
            LOG.debug("Arithmetic exception while resolving arithmetic operation value", (Throwable)e);
        }
        return null;
    }

    @CheckForNull
    private static Object resolveOr(BinaryExpressionTree binaryExpression) {
        Object left = ExpressionUtils.resolveAsConstant(binaryExpression.leftOperand());
        Object right = ExpressionUtils.resolveAsConstant(binaryExpression.rightOperand());
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Long) {
            Long leftLong = (Long)left;
            if (right instanceof Long) {
                Long rightLong = (Long)right;
                return leftLong | rightLong;
            }
        }
        if (left instanceof Long) {
            Long leftLong = (Long)left;
            if (right instanceof Integer) {
                Integer rightInt = (Integer)right;
                return leftLong | (long)rightInt.intValue();
            }
        }
        if (left instanceof Integer) {
            Integer leftInt = (Integer)left;
            if (right instanceof Long) {
                Long rightLong = (Long)right;
                return (long)leftInt.intValue() | rightLong;
            }
        }
        if (left instanceof Integer) {
            Integer leftInt = (Integer)left;
            if (right instanceof Integer) {
                Integer rightInt = (Integer)right;
                return leftInt | rightInt;
            }
        }
        return null;
    }
}

