/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import java.io.IOException;
import java.time.Clock;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.java.annotations.VisibleForTesting;

public class ExecutionTimeReport {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionTimeReport.class);
    private static final int MAX_REPORTED_FILES = 10;
    private static final long MIN_REPORTED_ANALYSIS_TIME_MS = 1000L;
    private static final long MIN_TOTAL_ANALYSIS_TIME_TO_REPORT_MS = 20000L;
    private static final Comparator<ExecutionTime> ORDER_BY_ANALYSIS_TIME_DESCENDING_AND_FILE_ASCENDING = (a, b) -> {
        int compare = Long.compare(b.analysisTime, a.analysisTime);
        return compare != 0 ? compare : a.file.compareTo(b.file);
    };
    private final LinkedList<ExecutionTime> recordedOrderedExecutionTime = new LinkedList();
    private long minRecordedOrderedExecutionTime = 1000L;
    private final Clock clock;
    private final long analysisStartTimeMS;
    private InputFile currentFile;
    private long currentFileStartTimeMS;

    public ExecutionTimeReport() {
        this(Clock.systemUTC());
    }

    @VisibleForTesting
    ExecutionTimeReport(Clock clock) {
        this.clock = clock;
        this.analysisStartTimeMS = clock.millis();
    }

    public void start(InputFile inputFile) {
        this.currentFile = inputFile;
        this.currentFileStartTimeMS = this.clock.millis();
    }

    public void end() {
        long currentAnalysisTime = this.clock.millis() - this.currentFileStartTimeMS;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Analysis time of {} ({}ms)", (Object)this.currentFile, (Object)currentAnalysisTime);
        } else if (currentAnalysisTime >= 1000L && LOG.isDebugEnabled()) {
            LOG.debug("Analysis time of {} ({}ms)", (Object)this.currentFile, (Object)currentAnalysisTime);
        }
        if (currentAnalysisTime >= this.minRecordedOrderedExecutionTime) {
            long currentFileLengthInBytes;
            try {
                currentFileLengthInBytes = this.currentFile.contents().length();
            }
            catch (IOException ignored) {
                currentFileLengthInBytes = -1L;
            }
            this.recordedOrderedExecutionTime.add(new ExecutionTime(this.currentFile.toString(), currentAnalysisTime, currentFileLengthInBytes));
            this.recordedOrderedExecutionTime.sort(ORDER_BY_ANALYSIS_TIME_DESCENDING_AND_FILE_ASCENDING);
            if (this.recordedOrderedExecutionTime.size() > 10) {
                this.recordedOrderedExecutionTime.removeLast();
                this.minRecordedOrderedExecutionTime = this.recordedOrderedExecutionTime.stream().mapToLong(e -> e.analysisTime).min().orElse(1000L);
            }
        }
        this.currentFile = null;
    }

    public void reportAsBatch() {
        this.report("Slowest analyzed files (batch mode enabled):");
    }

    public void report() {
        this.report("Slowest analyzed files:");
    }

    private void report(String message) {
        if (this.currentFile != null) {
            this.end();
        }
        long analysisEndTimeMS = this.clock.millis() - this.analysisStartTimeMS;
        if (LOG.isInfoEnabled() && analysisEndTimeMS >= 20000L && !this.recordedOrderedExecutionTime.isEmpty()) {
            LOG.info("{}{}{}", new Object[]{message, System.lineSeparator(), this});
        }
    }

    public String toString() {
        return this.recordedOrderedExecutionTime.stream().map(e -> "    " + e.file + " (" + e.analysisTime + "ms, " + e.lengthInBytes + "B)").collect(Collectors.joining(System.lineSeparator()));
    }

    private static class ExecutionTime {
        private final String file;
        private final long analysisTime;
        private final long lengthInBytes;

        public ExecutionTime(String file, long analysisTime, long lengthInBytes) {
            this.file = file;
            this.analysisTime = analysisTime;
            this.lengthInBytes = lengthInBytes;
        }
    }
}

