/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaRestrictedKeyword;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.location.Position;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.GuardedPatternTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.YieldStatementTree;

public class SyntaxHighlighterVisitor
extends SubscriptionVisitor {
    private final SonarComponents sonarComponents;
    private final Map<Tree.Kind, TypeOfText> typesByKind;
    private final Set<String> keywords;
    private final Set<String> restrictedKeywords;
    private NewHighlighting highlighting;
    private boolean withinModule = false;

    public SyntaxHighlighterVisitor(SonarComponents sonarComponents) {
        this.sonarComponents = sonarComponents;
        this.keywords = Collections.unmodifiableSet(Arrays.stream(JavaKeyword.keywordValues()).collect(Collectors.toSet()));
        this.restrictedKeywords = Collections.unmodifiableSet(Arrays.stream(JavaRestrictedKeyword.restrictedKeywordValues()).collect(Collectors.toSet()));
        EnumMap<Tree.Kind, TypeOfText> typesByKindMap = new EnumMap<Tree.Kind, TypeOfText>(Tree.Kind.class);
        typesByKindMap.put(Tree.Kind.STRING_LITERAL, TypeOfText.STRING);
        typesByKindMap.put(Tree.Kind.TEXT_BLOCK, TypeOfText.STRING);
        typesByKindMap.put(Tree.Kind.CHAR_LITERAL, TypeOfText.STRING);
        typesByKindMap.put(Tree.Kind.FLOAT_LITERAL, TypeOfText.CONSTANT);
        typesByKindMap.put(Tree.Kind.DOUBLE_LITERAL, TypeOfText.CONSTANT);
        typesByKindMap.put(Tree.Kind.LONG_LITERAL, TypeOfText.CONSTANT);
        typesByKindMap.put(Tree.Kind.INT_LITERAL, TypeOfText.CONSTANT);
        typesByKindMap.put(Tree.Kind.ANNOTATION, TypeOfText.ANNOTATION);
        typesByKindMap.put(Tree.Kind.VAR_TYPE, TypeOfText.KEYWORD);
        this.typesByKind = Collections.unmodifiableMap(typesByKindMap);
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        ArrayList<Tree.Kind> list = new ArrayList<Tree.Kind>(this.typesByKind.keySet());
        list.add(Tree.Kind.TOKEN);
        list.add(Tree.Kind.TRIVIA);
        list.add(Tree.Kind.MODULE);
        list.add(Tree.Kind.YIELD_STATEMENT);
        list.add(Tree.Kind.RECORD);
        list.add(Tree.Kind.CLASS);
        list.add(Tree.Kind.INTERFACE);
        list.add(Tree.Kind.MODIFIERS);
        list.add(Tree.Kind.GUARDED_PATTERN);
        return Collections.unmodifiableList(list);
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.highlighting = this.sonarComponents.highlightableFor(context.getInputFile());
        super.scanFile(context);
        this.highlighting.save();
    }

    @Override
    public void visitNode(Tree tree) {
        switch (tree.kind()) {
            case MODULE: {
                this.withinModule = true;
                return;
            }
            case ANNOTATION: {
                AnnotationTree annotationTree = (AnnotationTree)tree;
                this.highlight(annotationTree.atToken(), annotationTree.annotationType(), this.typesByKind.get((Object)Tree.Kind.ANNOTATION));
                return;
            }
            case YIELD_STATEMENT: {
                Optional.ofNullable(((YieldStatementTree)tree).yieldKeyword()).ifPresent(yieldKeyword -> this.highlight((Tree)yieldKeyword, TypeOfText.KEYWORD));
                return;
            }
            case RECORD: {
                this.highlight(((ClassTree)tree).declarationKeyword(), TypeOfText.KEYWORD);
                return;
            }
            case CLASS: 
            case INTERFACE: {
                Optional.ofNullable(((ClassTree)tree).permitsKeyword()).ifPresent(permitsKeyword -> this.highlight((Tree)permitsKeyword, TypeOfText.KEYWORD));
                return;
            }
            case MODIFIERS: {
                ModifiersTree modifiers = (ModifiersTree)tree;
                ModifiersUtils.findModifier(modifiers, Modifier.SEALED).ifPresent(modifier -> this.highlight((Tree)modifier, TypeOfText.KEYWORD));
                ModifiersUtils.findModifier(modifiers, Modifier.NON_SEALED).ifPresent(modifier -> this.highlight((Tree)modifier, TypeOfText.KEYWORD));
                return;
            }
            case GUARDED_PATTERN: {
                this.highlight(((GuardedPatternTree)tree).whenOperator(), TypeOfText.KEYWORD);
                return;
            }
        }
        this.highlight(tree, this.typesByKind.get((Object)tree.kind()));
    }

    @Override
    public void leaveNode(Tree tree) {
        if (tree.is(Tree.Kind.MODULE)) {
            this.withinModule = false;
        }
    }

    private void highlight(Tree tree, TypeOfText typeOfText) {
        this.highlight(tree, tree, typeOfText);
    }

    private void highlight(Tree from, Tree to, TypeOfText typeOfText) {
        Position first = Position.startOf(from);
        Position last = Position.endOf(to);
        this.highlighting.highlight(first.line(), first.columnOffset(), last.line(), last.columnOffset(), typeOfText);
    }

    @Override
    public void visitToken(SyntaxToken syntaxToken) {
        String text = syntaxToken.text();
        if (this.keywords.contains(text)) {
            if (SyntaxHighlighterVisitor.isInterfaceOfAnnotationType(syntaxToken)) {
                ClassTreeImpl annotationType = (ClassTreeImpl)syntaxToken.parent();
                this.highlight(annotationType.atToken(), annotationType.declarationKeyword(), TypeOfText.KEYWORD);
            } else {
                this.highlight(syntaxToken, TypeOfText.KEYWORD);
            }
        } else if (this.isRestrictedKeyword(syntaxToken)) {
            this.highlight(syntaxToken, TypeOfText.KEYWORD);
        }
    }

    private static boolean isInterfaceOfAnnotationType(SyntaxToken syntaxToken) {
        return JavaKeyword.INTERFACE.getValue().equals(syntaxToken.text()) && syntaxToken.parent().is(Tree.Kind.ANNOTATION_TYPE);
    }

    private boolean isRestrictedKeyword(SyntaxToken syntaxToken) {
        return this.withinModule && this.restrictedKeywords.contains(syntaxToken.text()) && !syntaxToken.parent().is(Tree.Kind.IDENTIFIER);
    }

    @Override
    public void visitTrivia(SyntaxTrivia syntaxTrivia) {
        boolean isJavadoc = syntaxTrivia.comment().startsWith("/**");
        TypeOfText typeOfText = isJavadoc ? TypeOfText.STRUCTURED_COMMENT : TypeOfText.COMMENT;
        Position start = Position.startOf(syntaxTrivia);
        Position end = Position.endOf(syntaxTrivia);
        this.highlighting.highlight(start.line(), start.columnOffset(), end.line(), end.columnOffset(), typeOfText);
    }
}

