/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.plugins.java.api.location.Position;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;

public final class LineUtils {
    private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("\r\n|[\n\r]");

    private LineUtils() {
    }

    public static int startLine(Tree tree) {
        return LineUtils.startLine(tree.firstToken());
    }

    public static int endLine(Tree tree) {
        return LineUtils.endLine(tree.lastToken());
    }

    public static int startLine(SyntaxToken token) {
        return Position.startOf(token).line();
    }

    public static int endLine(SyntaxToken token) {
        return Position.endOf(token).line();
    }

    public static int startLine(SyntaxTrivia trivia) {
        return Position.startOf(trivia).line();
    }

    public static int endLine(SyntaxTrivia trivia) {
        return Position.endOf(trivia).line();
    }

    public static List<String> splitLines(String content) {
        ArrayList<String> lines = new ArrayList<String>();
        Matcher matcher = LINE_BREAK_PATTERN.matcher(content);
        int pos = 0;
        while (matcher.find()) {
            lines.add(content.substring(pos, matcher.start()));
            pos = matcher.end();
        }
        if (pos == 0 || pos < content.length()) {
            lines.add(content.substring(pos));
        }
        return lines;
    }
}

