/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.testing;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.java.SonarComponents;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.FluentReporting;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.testing.JavaIssueBuilderForTests;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.caching.CacheContext;
import org.sonar.plugins.java.api.semantic.Sema;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.Tree;

public class JavaFileScannerContextForTests
extends DefaultJavaFileScannerContext {
    private final Set<AnalyzerMessage> issues = new LinkedHashSet<AnalyzerMessage>();
    private final Map<AnalyzerMessage.TextSpan, List<JavaQuickFix>> quickFixes = new HashMap<AnalyzerMessage.TextSpan, List<JavaQuickFix>>();

    public JavaFileScannerContextForTests(CompilationUnitTree tree, InputFile inputFile, Sema semanticModel, @Nullable SonarComponents sonarComponents, JavaVersion javaVersion, boolean failedParsing, boolean inAndroidContext, @Nullable CacheContext cacheContext) {
        super(tree, inputFile, semanticModel, sonarComponents, javaVersion, failedParsing, inAndroidContext, cacheContext);
    }

    public Set<AnalyzerMessage> getIssues() {
        return this.issues;
    }

    public Map<AnalyzerMessage.TextSpan, List<JavaQuickFix>> getQuickFixes() {
        return this.quickFixes;
    }

    @Override
    public void addIssueOnProject(JavaCheck javaCheck, String message) {
        this.issues.add(new AnalyzerMessage(javaCheck, this.sonarComponents.project(), null, message, 0));
    }

    @Override
    public void addIssue(int line, JavaCheck javaCheck, String message, @Nullable Integer cost) {
        this.issues.add(new AnalyzerMessage(javaCheck, (InputComponent)this.getInputFile(), line, message, cost != null ? cost : 0));
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree tree, String message) {
        JavaFileScannerContextForTests.throwIfEndOfAnalysisCheck(javaCheck);
        this.newIssue().forRule(javaCheck).onTree(tree).withMessage(message).report();
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree syntaxNode, String message, List<JavaFileScannerContext.Location> secondary, @Nullable Integer cost) {
        JavaFileScannerContextForTests.throwIfEndOfAnalysisCheck(javaCheck);
        this.newIssue().forRule(javaCheck).onTree(syntaxNode).withMessage(message).withSecondaries(secondary).withCost(cost == null ? 0 : cost).report();
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree startTree, Tree endTree, String message) {
        JavaFileScannerContextForTests.throwIfEndOfAnalysisCheck(javaCheck);
        this.newIssue().forRule(javaCheck).onRange(startTree, endTree).withMessage(message).report();
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree startTree, Tree endTree, String message, List<JavaFileScannerContext.Location> secondary, @Nullable Integer cost) {
        JavaFileScannerContextForTests.throwIfEndOfAnalysisCheck(javaCheck);
        this.newIssue().forRule(javaCheck).onRange(startTree, endTree).withMessage(message).withSecondaries(secondary).withCost(cost == null ? 0 : cost).report();
    }

    @Override
    public void reportIssueWithFlow(JavaCheck javaCheck, Tree syntaxNode, String message, Iterable<List<JavaFileScannerContext.Location>> flows, @Nullable Integer cost) {
        JavaFileScannerContextForTests.throwIfEndOfAnalysisCheck(javaCheck);
        this.newIssue().forRule(javaCheck).onTree(syntaxNode).withMessage(message).withFlows(StreamSupport.stream(flows.spliterator(), false).toList()).withCost(cost == null ? 0 : cost).report();
    }

    @Override
    public void reportIssue(AnalyzerMessage message) {
        this.issues.add(message);
    }

    @Override
    public AnalyzerMessage createAnalyzerMessage(JavaCheck javaCheck, Tree startTree, String message) {
        return JavaFileScannerContextForTests.createAnalyzerMessage(this.getInputFile(), javaCheck, startTree, null, message, Collections.emptyList(), null);
    }

    @Override
    public FluentReporting.JavaIssueBuilder newIssue() {
        return new JavaIssueBuilderForTests(this.getInputFile(), this.issues, this.quickFixes);
    }
}

