/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.ExecutionDataStore;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.CoverageMeasuresBuilder;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.test.MutableTestCase;
import org.sonar.api.test.MutableTestPlan;
import org.sonar.api.test.MutableTestable;
import org.sonar.api.test.Testable;
import org.sonar.java.JavaClasspath;
import org.sonar.plugins.jacoco.ExecutionDataVisitor;
import org.sonar.plugins.jacoco.JaCoCoExtensions;
import org.sonar.plugins.jacoco.JacocoReportReader;
import org.sonar.plugins.java.api.JavaResourceLocator;

public abstract class AbstractAnalyzer {
    private final ResourcePerspectives perspectives;
    private final FileSystem fileSystem;
    private final PathResolver pathResolver;
    private final JavaResourceLocator javaResourceLocator;
    private final boolean readCoveragePerTests;
    private Map<String, File> classFilesCache;
    private JavaClasspath javaClasspath;
    private JacocoReportReader jacocoReportReader;

    public AbstractAnalyzer(ResourcePerspectives perspectives, FileSystem fileSystem, PathResolver pathResolver, JavaResourceLocator javaResourceLocator, JavaClasspath javaClasspath) {
        this(perspectives, fileSystem, pathResolver, javaResourceLocator, javaClasspath, true);
    }

    public AbstractAnalyzer(ResourcePerspectives perspectives, FileSystem fileSystem, PathResolver pathResolver, JavaResourceLocator javaResourceLocator, JavaClasspath javaClasspath, boolean readCoveragePerTests) {
        this.perspectives = perspectives;
        this.fileSystem = fileSystem;
        this.pathResolver = pathResolver;
        this.javaResourceLocator = javaResourceLocator;
        this.readCoveragePerTests = readCoveragePerTests;
        this.javaClasspath = javaClasspath;
    }

    private static String fullyQualifiedClassName(String packageName, String simpleClassName) {
        return ("".equals(packageName) ? "" : packageName + "/") + StringUtils.substringBeforeLast((String)simpleClassName, (String)".");
    }

    private Resource getResource(ISourceFileCoverage coverage, SensorContext context) {
        String className = AbstractAnalyzer.fullyQualifiedClassName(coverage.getPackageName(), coverage.getName());
        Resource resourceInContext = context.getResource(this.javaResourceLocator.findResourceByClassName(className));
        if (resourceInContext == null) {
            return null;
        }
        if (ResourceUtils.isUnitTestClass((Resource)resourceInContext)) {
            return null;
        }
        return resourceInContext;
    }

    public final void analyse(Project project, SensorContext context) {
        this.classFilesCache = Maps.newHashMap();
        for (File classesDir : this.javaClasspath.getBinaryDirs()) {
            this.populateClassFilesCache(classesDir, "");
        }
        if (this.classFilesCache.isEmpty()) {
            JaCoCoExtensions.LOG.info("No JaCoCo analysis of project coverage can be done since there is no class files.");
            return;
        }
        String path = this.getReportPath(project);
        File jacocoExecutionData = this.pathResolver.relativeFile(this.fileSystem.baseDir(), path);
        this.readExecutionData(jacocoExecutionData, context);
        this.classFilesCache = null;
    }

    private void populateClassFilesCache(File dir, String path) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.populateClassFilesCache(file, path + file.getName() + "/");
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String className = path + StringUtils.removeEnd((String)file.getName(), (String)".class");
            this.classFilesCache.put(className, file);
        }
    }

    private void readExecutionData(File jacocoExecutionData, SensorContext context) {
        if (jacocoExecutionData == null || !jacocoExecutionData.isFile()) {
            JaCoCoExtensions.LOG.info("Project coverage is set to 0% as no JaCoCo execution data has been dumped: {}", (Object)jacocoExecutionData);
            jacocoExecutionData = null;
        }
        ExecutionDataVisitor executionDataVisitor = new ExecutionDataVisitor();
        this.jacocoReportReader = new JacocoReportReader(jacocoExecutionData).readJacocoReport(executionDataVisitor, executionDataVisitor);
        boolean collectedCoveragePerTest = this.readCoveragePerTests(context, executionDataVisitor);
        CoverageBuilder coverageBuilder = this.jacocoReportReader.analyzeFiles(executionDataVisitor.getMerged(), this.classFilesCache.values());
        int analyzedResources = 0;
        for (ISourceFileCoverage coverage : coverageBuilder.getSourceFiles()) {
            Resource resource = this.getResource(coverage, context);
            if (resource == null) continue;
            CoverageMeasuresBuilder builder = AbstractAnalyzer.analyzeFile(resource, coverage);
            this.saveMeasures(context, resource, builder.createMeasures());
            ++analyzedResources;
        }
        if (analyzedResources == 0) {
            JaCoCoExtensions.LOG.warn("Coverage information was not collected. Perhaps you forget to include debug information into compiled classes?");
        } else if (collectedCoveragePerTest) {
            JaCoCoExtensions.LOG.info("Information about coverage per test has been collected.");
        } else if (jacocoExecutionData != null) {
            JaCoCoExtensions.LOG.info("No information about coverage per test.");
        }
    }

    private boolean readCoveragePerTests(SensorContext context, ExecutionDataVisitor executionDataVisitor) {
        boolean collectedCoveragePerTest = false;
        if (this.readCoveragePerTests) {
            for (Map.Entry<String, ExecutionDataStore> entry : executionDataVisitor.getSessions().entrySet()) {
                if (!this.analyzeLinesCoveredByTests(entry.getKey(), entry.getValue(), context)) continue;
                collectedCoveragePerTest = true;
            }
        }
        return collectedCoveragePerTest;
    }

    private boolean analyzeLinesCoveredByTests(String sessionId, ExecutionDataStore executionDataStore, SensorContext context) {
        int i = sessionId.indexOf(32);
        if (i < 0) {
            return false;
        }
        String testClassName = sessionId.substring(0, i);
        String testName = sessionId.substring(i + 1);
        Resource testResource = context.getResource(this.javaResourceLocator.findResourceByClassName(testClassName));
        if (testResource == null) {
            return false;
        }
        boolean result = false;
        CoverageBuilder coverageBuilder = this.jacocoReportReader.analyzeFiles(executionDataStore, this.classFilesOfStore(executionDataStore));
        for (ISourceFileCoverage coverage : coverageBuilder.getSourceFiles()) {
            CoverageMeasuresBuilder builder;
            List<Integer> coveredLines;
            Resource resource = this.getResource(coverage, context);
            if (resource == null || (coveredLines = AbstractAnalyzer.getCoveredLines(builder = AbstractAnalyzer.analyzeFile(resource, coverage))).isEmpty() || !this.addCoverage(resource, testResource, testName, coveredLines)) continue;
            result = true;
        }
        return result;
    }

    private Collection<File> classFilesOfStore(ExecutionDataStore executionDataStore) {
        ArrayList result = Lists.newArrayList();
        for (ExecutionData data : executionDataStore.getContents()) {
            String vmClassName = data.getName();
            File classFile = this.classFilesCache.get(vmClassName);
            if (classFile == null) continue;
            result.add(classFile);
        }
        return result;
    }

    private static List<Integer> getCoveredLines(CoverageMeasuresBuilder builder) {
        ArrayList linesCover = Lists.newArrayList();
        for (Map.Entry hitsByLine : builder.getHitsByLine().entrySet()) {
            if ((Integer)hitsByLine.getValue() <= 0) continue;
            linesCover.add(hitsByLine.getKey());
        }
        return linesCover;
    }

    private boolean addCoverage(Resource resource, Resource testFile, String testName, List<Integer> coveredLines) {
        MutableTestPlan testPlan;
        boolean result = false;
        Testable testAbleFile = (Testable)this.perspectives.as(MutableTestable.class, resource);
        if (testAbleFile != null && (testPlan = (MutableTestPlan)this.perspectives.as(MutableTestPlan.class, testFile)) != null) {
            for (MutableTestCase testCase : testPlan.testCasesByName(testName)) {
                testCase.setCoverageBlock(testAbleFile, coveredLines);
                result = true;
            }
        }
        return result;
    }

    private static CoverageMeasuresBuilder analyzeFile(Resource resource, ISourceFileCoverage coverage) {
        CoverageMeasuresBuilder builder = CoverageMeasuresBuilder.create();
        block5: for (int lineId = coverage.getFirstLine(); lineId <= coverage.getLastLine(); ++lineId) {
            int hits;
            ILine line = coverage.getLine(lineId);
            switch (line.getInstructionCounter().getStatus()) {
                case 2: 
                case 3: {
                    hits = 1;
                    break;
                }
                case 1: {
                    hits = 0;
                    break;
                }
                case 0: {
                    continue block5;
                }
                default: {
                    JaCoCoExtensions.LOG.warn("Unknown status for line {} in {}", (Object)lineId, (Object)resource);
                    continue block5;
                }
            }
            builder.setHits(lineId, hits);
            ICounter branchCounter = line.getBranchCounter();
            int conditions = branchCounter.getTotalCount();
            if (conditions <= 0) continue;
            int coveredConditions = branchCounter.getCoveredCount();
            builder.setConditions(lineId, conditions, coveredConditions);
        }
        return builder;
    }

    protected abstract void saveMeasures(SensorContext var1, Resource var2, Collection<Measure> var3);

    protected abstract String getReportPath(Project var1);
}

