/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.io.File;
import java.util.Collection;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.java.JavaClasspath;
import org.sonar.plugins.jacoco.AbstractAnalyzer;
import org.sonar.plugins.jacoco.JaCoCoExtensions;
import org.sonar.plugins.jacoco.JaCoCoReportMerger;
import org.sonar.plugins.jacoco.JacocoConfiguration;
import org.sonar.plugins.java.api.JavaResourceLocator;

public class JaCoCoOverallSensor
implements Sensor {
    public static final String JACOCO_OVERALL = "jacoco-overall.exec";
    private final JacocoConfiguration configuration;
    private final ResourcePerspectives perspectives;
    private final ModuleFileSystem fileSystem;
    private final PathResolver pathResolver;
    private final JavaResourceLocator javaResourceLocator;
    private final JavaClasspath javaClasspath;

    public JaCoCoOverallSensor(JacocoConfiguration configuration, ResourcePerspectives perspectives, ModuleFileSystem fileSystem, PathResolver pathResolver, JavaResourceLocator javaResourceLocator, JavaClasspath javaClasspath) {
        this.configuration = configuration;
        this.perspectives = perspectives;
        this.fileSystem = fileSystem;
        this.pathResolver = pathResolver;
        this.javaResourceLocator = javaResourceLocator;
        this.javaClasspath = javaClasspath;
    }

    public boolean shouldExecuteOnProject(Project project) {
        File reportUTs = this.pathResolver.relativeFile(this.fileSystem.baseDir(), this.configuration.getReportPath());
        File reportITs = this.pathResolver.relativeFile(this.fileSystem.baseDir(), this.configuration.getItReportPath());
        boolean foundOneReport = reportUTs.exists() || reportITs.exists();
        boolean shouldExecute = this.configuration.shouldExecuteOnProject(foundOneReport);
        if (!foundOneReport && shouldExecute) {
            JaCoCoExtensions.LOG.info("JaCoCoOverallSensor: JaCoCo reports not found.");
        }
        return shouldExecute;
    }

    public void analyse(Project project, SensorContext context) {
        File reportUTs = this.pathResolver.relativeFile(this.fileSystem.baseDir(), this.configuration.getReportPath());
        File reportITs = this.pathResolver.relativeFile(this.fileSystem.baseDir(), this.configuration.getItReportPath());
        File reportOverall = new File(this.fileSystem.workingDir(), JACOCO_OVERALL);
        reportOverall.getParentFile().mkdirs();
        JaCoCoReportMerger.mergeReports(reportOverall, reportUTs, reportITs);
        new OverallAnalyzer(reportOverall, this.perspectives).analyse(project, context);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    class OverallAnalyzer
    extends AbstractAnalyzer {
        private final File report;

        OverallAnalyzer(File report, ResourcePerspectives perspectives) {
            super(perspectives, JaCoCoOverallSensor.this.fileSystem, JaCoCoOverallSensor.this.pathResolver, JaCoCoOverallSensor.this.javaResourceLocator, JaCoCoOverallSensor.this.javaClasspath, false);
            this.report = report;
        }

        @Override
        protected String getReportPath(Project project) {
            return this.report.getAbsolutePath();
        }

        @Override
        protected void saveMeasures(SensorContext context, Resource resource, Collection<Measure> measures) {
            for (Measure measure : measures) {
                Measure mergedMeasure = this.convertForOverall(measure);
                if (mergedMeasure == null) continue;
                context.saveMeasure(resource, mergedMeasure);
            }
        }

        private Measure convertForOverall(Measure measure) {
            Measure itMeasure = null;
            if (CoreMetrics.LINES_TO_COVER.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.OVERALL_LINES_TO_COVER, measure.getValue());
            } else if (CoreMetrics.UNCOVERED_LINES.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.OVERALL_UNCOVERED_LINES, measure.getValue());
            } else if (CoreMetrics.COVERAGE_LINE_HITS_DATA.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.OVERALL_COVERAGE_LINE_HITS_DATA, measure.getData());
            } else if (CoreMetrics.CONDITIONS_TO_COVER.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.OVERALL_CONDITIONS_TO_COVER, measure.getValue());
            } else if (CoreMetrics.UNCOVERED_CONDITIONS.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.OVERALL_UNCOVERED_CONDITIONS, measure.getValue());
            } else if (CoreMetrics.COVERED_CONDITIONS_BY_LINE.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.OVERALL_COVERED_CONDITIONS_BY_LINE, measure.getData());
            } else if (CoreMetrics.CONDITIONS_BY_LINE.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.OVERALL_CONDITIONS_BY_LINE, measure.getData());
            }
            return itMeasure;
        }
    }
}

