/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.coverage.CoverageType;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.java.JavaClasspath;
import org.sonar.plugins.jacoco.AbstractAnalyzer;
import org.sonar.plugins.jacoco.JaCoCoExtensions;
import org.sonar.plugins.jacoco.JacocoConfiguration;
import org.sonar.plugins.java.api.JavaResourceLocator;

public class JaCoCoItSensor
implements Sensor {
    private final JacocoConfiguration configuration;
    private final ResourcePerspectives perspectives;
    private final FileSystem fileSystem;
    private final PathResolver pathResolver;
    private final JavaResourceLocator javaResourceLocator;
    private final JavaClasspath javaClasspath;

    public JaCoCoItSensor(JacocoConfiguration configuration, ResourcePerspectives perspectives, FileSystem fileSystem, PathResolver pathResolver, JavaResourceLocator javaResourceLocator, JavaClasspath javaClasspath) {
        this.configuration = configuration;
        this.perspectives = perspectives;
        this.fileSystem = fileSystem;
        this.pathResolver = pathResolver;
        this.javaResourceLocator = javaResourceLocator;
        this.javaClasspath = javaClasspath;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("java").name("JaCoCoItSensor");
    }

    public void execute(SensorContext context) {
        if (this.shouldExecuteOnProject()) {
            new ITAnalyzer().analyse(context);
        }
    }

    @VisibleForTesting
    boolean shouldExecuteOnProject() {
        File report = this.pathResolver.relativeFile(this.fileSystem.baseDir(), this.configuration.getItReportPath());
        boolean foundReport = report.isFile();
        if (!foundReport) {
            JaCoCoExtensions.LOG.info("JaCoCoItSensor: JaCoCo IT report not found: " + report.getPath());
        }
        return this.configuration.shouldExecuteOnProject(foundReport);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    class ITAnalyzer
    extends AbstractAnalyzer {
        public ITAnalyzer() {
            super(JaCoCoItSensor.this.perspectives, JaCoCoItSensor.this.fileSystem, JaCoCoItSensor.this.pathResolver, JaCoCoItSensor.this.javaResourceLocator, JaCoCoItSensor.this.javaClasspath);
        }

        @Override
        protected CoverageType coverageType() {
            return CoverageType.IT;
        }

        @Override
        protected String getReportPath() {
            return JaCoCoItSensor.this.configuration.getItReportPath();
        }
    }
}

