/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang.BooleanUtils;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.previous.core.data.ExecutionDataWriter;
import org.sonar.plugins.jacoco.JacocoReportReader;
import org.sonar.squidbridge.api.AnalysisException;

public final class JaCoCoReportMerger {
    private JaCoCoReportMerger() {
    }

    public static void mergeReports(File reportOverall, File ... reports) {
        SessionInfoStore infoStore = new SessionInfoStore();
        ExecutionDataStore dataStore = new ExecutionDataStore();
        boolean isCurrentVersionFormat = JaCoCoReportMerger.loadSourceFiles((ISessionInfoVisitor)infoStore, (IExecutionDataVisitor)dataStore, reports);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(reportOverall));){
            Object visitor = isCurrentVersionFormat ? new org.jacoco.core.data.ExecutionDataWriter((OutputStream)outputStream) : new ExecutionDataWriter((OutputStream)outputStream);
            infoStore.accept((ISessionInfoVisitor)visitor);
            dataStore.accept((IExecutionDataVisitor)visitor);
        }
        catch (IOException e) {
            throw new AnalysisException(String.format("Unable to write overall coverage report %s", reportOverall.getAbsolutePath()), (Throwable)e);
        }
    }

    private static boolean loadSourceFiles(ISessionInfoVisitor infoStore, IExecutionDataVisitor dataStore, File ... reports) {
        Boolean isCurrentVersionFormat = null;
        for (File report : reports) {
            if (!report.isFile()) continue;
            JacocoReportReader jacocoReportReader = new JacocoReportReader(report).readJacocoReport(dataStore, infoStore);
            boolean reportFormatIsCurrent = jacocoReportReader.useCurrentBinaryFormat();
            if (isCurrentVersionFormat == null) {
                isCurrentVersionFormat = reportFormatIsCurrent;
                continue;
            }
            if (isCurrentVersionFormat.equals(reportFormatIsCurrent)) continue;
            throw new IllegalStateException("You are trying to merge two different JaCoCo binary formats. Please use only one version of JaCoCo.");
        }
        return BooleanUtils.isNotFalse(isCurrentVersionFormat);
    }
}

