/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.coverage.CoverageType;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.config.Settings;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.java.JavaClasspath;
import org.sonar.plugins.jacoco.AbstractAnalyzer;
import org.sonar.plugins.jacoco.JaCoCoExtensions;
import org.sonar.plugins.jacoco.JaCoCoReportMerger;
import org.sonar.plugins.jacoco.JacocoConfiguration;
import org.sonar.plugins.java.api.JavaResourceLocator;

public class JaCoCoSensor
implements Sensor {
    private static final String JACOCO_MERGED_FILENAME = "jacoco-merged.exec";
    private final JacocoConfiguration configuration;
    private final ResourcePerspectives perspectives;
    private final FileSystem fileSystem;
    private final PathResolver pathResolver;
    private final JavaResourceLocator javaResourceLocator;
    private final JavaClasspath javaClasspath;

    public JaCoCoSensor(JacocoConfiguration configuration, ResourcePerspectives perspectives, FileSystem fileSystem, PathResolver pathResolver, JavaResourceLocator javaResourceLocator, JavaClasspath javaClasspath) {
        this.configuration = configuration;
        this.perspectives = perspectives;
        this.fileSystem = fileSystem;
        this.pathResolver = pathResolver;
        this.javaResourceLocator = javaResourceLocator;
        this.javaClasspath = javaClasspath;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("java").name("JaCoCoSensor");
    }

    public void execute(SensorContext context) {
        if (context.getSonarQubeVersion().isGreaterThanOrEqual(JacocoConfiguration.SQ_6_2)) {
            File reportMerged;
            Set<File> reportPaths;
            if (context.settings().hasKey("sonar.jacoco.reportMissing.force.zero")) {
                JaCoCoExtensions.LOG.warn("Property '{}' is deprecated and its value will be ignored.", (Object)"sonar.jacoco.reportMissing.force.zero");
            }
            if ((reportPaths = JaCoCoSensor.getReportPaths(context)).isEmpty()) {
                return;
            }
            if (reportPaths.size() == 1) {
                reportMerged = reportPaths.iterator().next();
            } else {
                reportMerged = new File(context.fileSystem().workDir(), JACOCO_MERGED_FILENAME);
                reportMerged.getParentFile().mkdirs();
                JaCoCoReportMerger.mergeReports(reportMerged, reportPaths.toArray(new File[0]));
            }
            new UnitTestsAnalyzer(reportMerged).analyse(context);
        } else {
            String reportPath = context.settings().getString("sonar.jacoco.reportPath");
            File report = this.pathResolver.relativeFile(this.fileSystem.baseDir(), reportPath);
            boolean foundReport = report.isFile();
            if (!foundReport) {
                JaCoCoExtensions.LOG.info("JaCoCoSensor: JaCoCo report not found : " + report.getPath());
            }
            if (this.configuration.shouldExecuteOnProject(foundReport)) {
                new UnitTestsAnalyzer(report).analyse(context);
            }
        }
    }

    private static Set<File> getReportPaths(SensorContext context) {
        File report;
        HashSet<File> reportPaths = new HashSet<File>();
        Settings settings = context.settings();
        FileSystem fs = context.fileSystem();
        for (String reportPath : settings.getStringArray("sonar.jacoco.reportPaths")) {
            File report2 = fs.resolvePath(reportPath);
            if (!report2.isFile()) {
                if (!settings.hasKey("sonar.jacoco.reportPaths")) continue;
                JaCoCoExtensions.LOG.info("JaCoCo report not found: '{}'", (Object)reportPath);
                continue;
            }
            reportPaths.add(report2);
        }
        if (settings.hasKey("sonar.jacoco.reportPath")) {
            JaCoCoExtensions.LOG.warn("Property '{}' is deprecated. Please use '{}' instead.", (Object)"sonar.jacoco.reportPath", (Object)"sonar.jacoco.reportPaths");
            report = fs.resolvePath(settings.getString("sonar.jacoco.reportPath"));
            if (!report.isFile()) {
                JaCoCoExtensions.LOG.info("JaCoCo UT report not found: '{}'", (Object)settings.getString("sonar.jacoco.reportPath"));
            } else {
                reportPaths.add(report);
            }
        }
        if (settings.hasKey("sonar.jacoco.itReportPath")) {
            JaCoCoExtensions.LOG.warn("Property '{}' is deprecated. Please use '{}' instead.", (Object)"sonar.jacoco.itReportPath", (Object)"sonar.jacoco.reportPaths");
            report = fs.resolvePath(settings.getString("sonar.jacoco.itReportPath"));
            if (!report.isFile()) {
                JaCoCoExtensions.LOG.info("JaCoCo IT report not found: '{}'", (Object)settings.getString("sonar.jacoco.itReportPath"));
            } else {
                reportPaths.add(report);
            }
        }
        return reportPaths;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    class UnitTestsAnalyzer
    extends AbstractAnalyzer {
        private final File report;

        public UnitTestsAnalyzer(File report) {
            super(JaCoCoSensor.this.perspectives, JaCoCoSensor.this.javaResourceLocator, JaCoCoSensor.this.javaClasspath);
            this.report = report;
        }

        @Override
        protected CoverageType coverageType() {
            return CoverageType.UNIT;
        }

        @Override
        protected File getReport() {
            return this.report;
        }
    }
}

