/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.annotation.Nullable;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.previous.core.data.ExecutionDataReader;
import org.sonar.plugins.jacoco.JaCoCoExtensions;
import org.sonar.squidbridge.api.AnalysisException;

public class JacocoReportReader {
    @Nullable
    private final File jacocoExecutionData;
    private final boolean useCurrentBinaryFormat;

    public JacocoReportReader(@Nullable File jacocoExecutionData) {
        this.jacocoExecutionData = jacocoExecutionData;
        this.useCurrentBinaryFormat = JacocoReportReader.isCurrentReportFormat(jacocoExecutionData);
    }

    public JacocoReportReader readJacocoReport(IExecutionDataVisitor executionDataVisitor, ISessionInfoVisitor sessionInfoStore) {
        if (this.jacocoExecutionData == null) {
            return this;
        }
        JaCoCoExtensions.LOG.info("Analysing {}", (Object)this.jacocoExecutionData);
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(this.jacocoExecutionData));){
            org.jacoco.core.data.ExecutionDataReader reader;
            if (this.useCurrentBinaryFormat) {
                reader = new org.jacoco.core.data.ExecutionDataReader((InputStream)inputStream);
                reader.setSessionInfoVisitor(sessionInfoStore);
                reader.setExecutionDataVisitor(executionDataVisitor);
                reader.read();
            } else {
                reader = new ExecutionDataReader((InputStream)inputStream);
                reader.setSessionInfoVisitor(sessionInfoStore);
                reader.setExecutionDataVisitor(executionDataVisitor);
                reader.read();
            }
        }
        catch (IOException e) {
            throw new AnalysisException(String.format("Unable to read %s", this.jacocoExecutionData.getAbsolutePath()), (Throwable)e);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isCurrentReportFormat(@Nullable File jacocoExecutionData) {
        if (jacocoExecutionData == null) {
            return true;
        }
        try (DataInputStream dis = new DataInputStream(new FileInputStream(jacocoExecutionData));){
            boolean isCurrentFormat;
            byte firstByte = dis.readByte();
            Preconditions.checkState((firstByte == 1 ? 1 : 0) != 0);
            Preconditions.checkState((dis.readChar() == '\uc0c0' ? 1 : 0) != 0);
            char version = dis.readChar();
            boolean bl = isCurrentFormat = version == ExecutionDataWriter.FORMAT_VERSION;
            if (!isCurrentFormat) {
                JaCoCoExtensions.LOG.warn("You are not using the latest JaCoCo binary format version, please consider upgrading to latest JaCoCo version.");
            }
            boolean bl2 = isCurrentFormat;
            return bl2;
        }
        catch (IOException | IllegalStateException e) {
            throw new AnalysisException(String.format("Unable to read %s to determine JaCoCo binary format.", jacocoExecutionData.getAbsolutePath()), (Throwable)e);
        }
    }

    public boolean useCurrentBinaryFormat() {
        return this.useCurrentBinaryFormat;
    }

    public CoverageBuilder analyzeFiles(ExecutionDataStore executionDataStore, Collection<File> classFiles) {
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        if (this.useCurrentBinaryFormat) {
            Analyzer analyzer = new Analyzer(executionDataStore, (ICoverageVisitor)coverageBuilder);
            for (File classFile : classFiles) {
                JacocoReportReader.analyzeClassFile(analyzer, classFile);
            }
        } else {
            org.jacoco.previous.core.analysis.Analyzer analyzer = new org.jacoco.previous.core.analysis.Analyzer(executionDataStore, (ICoverageVisitor)coverageBuilder);
            for (File classFile : classFiles) {
                JacocoReportReader.analyzeClassFile(analyzer, classFile);
            }
        }
        return coverageBuilder;
    }

    private static void analyzeClassFile(org.jacoco.previous.core.analysis.Analyzer analyzer, File classFile) {
        try (FileInputStream inputStream = new FileInputStream(classFile);){
            analyzer.analyzeClass((InputStream)inputStream, classFile.getPath());
        }
        catch (IOException e) {
            JaCoCoExtensions.LOG.warn("Exception during analysis of file " + classFile.getAbsolutePath(), (Throwable)e);
        }
    }

    private static void analyzeClassFile(Analyzer analyzer, File classFile) {
        try (FileInputStream inputStream = new FileInputStream(classFile);){
            analyzer.analyzeClass((InputStream)inputStream, classFile.getPath());
        }
        catch (IOException e) {
            JaCoCoExtensions.LOG.warn("Exception during analysis of file " + classFile.getAbsolutePath(), (Throwable)e);
        }
    }
}

