/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.config.Configuration;
import org.sonar.java.AnalysisWarningsWrapper;
import org.sonar.java.JavaClasspath;
import org.sonar.plugins.jacoco.JaCoCoExtensions;
import org.sonar.plugins.jacoco.JaCoCoReportMerger;
import org.sonar.plugins.jacoco.UnitTestAnalyzer;
import org.sonar.plugins.java.api.JavaResourceLocator;

public class JaCoCoSensor
implements Sensor {
    private static final String JACOCO_MERGED_FILENAME = "jacoco-merged.exec";
    private final ResourcePerspectives perspectives;
    private final JavaResourceLocator javaResourceLocator;
    private final JavaClasspath javaClasspath;
    static final String JACOCO_XML_PROPERTY = "sonar.coverage.jacoco.xmlReportPaths";
    private static final String[] JACOCO_XML_DEFAULT_PATHS = new String[]{"target/site/jacoco/jacoco.xml", "build/reports/jacoco/test/jacocoTestReport.xml"};
    private AnalysisWarningsWrapper analysisWarnings;

    public JaCoCoSensor(ResourcePerspectives perspectives, JavaResourceLocator javaResourceLocator, JavaClasspath javaClasspath) {
        this(perspectives, javaResourceLocator, javaClasspath, AnalysisWarningsWrapper.NOOP_ANALYSIS_WARNINGS);
    }

    public JaCoCoSensor(ResourcePerspectives perspectives, JavaResourceLocator javaResourceLocator, JavaClasspath javaClasspath, AnalysisWarningsWrapper analysisWarnings) {
        this.perspectives = perspectives;
        this.javaResourceLocator = javaResourceLocator;
        this.javaClasspath = javaClasspath;
        this.analysisWarnings = analysisWarnings;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("java").name("JaCoCoSensor");
    }

    public void execute(SensorContext context) {
        List<Report> reports;
        Configuration config = context.config();
        if (config.hasKey("sonar.jacoco.reportMissing.force.zero")) {
            this.addAnalysisWarning("Property '%s' is deprecated and its value will be ignored.", "sonar.jacoco.reportMissing.force.zero");
        }
        if ((reports = JaCoCoSensor.getReportPaths(context)).isEmpty()) {
            return;
        }
        boolean hasXmlReport = JaCoCoSensor.hasXmlReport(context);
        this.warnAboutDeprecatedProperties(config, reports, hasXmlReport);
        if (hasXmlReport) {
            JaCoCoExtensions.LOG.debug("JaCoCo XML report found, skipping processing of binary JaCoCo exec report.", (Object)JACOCO_XML_PROPERTY);
            return;
        }
        File reportMerged = JaCoCoSensor.mergeJacocoReports(context, reports);
        new UnitTestAnalyzer(reportMerged, this.perspectives, this.javaResourceLocator, this.javaClasspath, this.analysisWarnings).analyse(context);
    }

    private static File mergeJacocoReports(SensorContext context, List<Report> reportPaths) {
        File reportMerged;
        if (reportPaths.size() == 1) {
            reportMerged = reportPaths.get((int)0).file;
        } else {
            reportMerged = new File(context.fileSystem().workDir(), JACOCO_MERGED_FILENAME);
            reportMerged.getParentFile().mkdirs();
            File[] reports = (File[])reportPaths.stream().map(report -> report.file).toArray(File[]::new);
            JaCoCoReportMerger.mergeReports(reportMerged, reports);
        }
        return reportMerged;
    }

    private void warnAboutDeprecatedProperties(Configuration config, List<Report> reports, boolean hasXmlReport) {
        Set<String> usedProperties = reports.stream().map(report -> report.propertyKey).collect(Collectors.toSet());
        usedProperties.forEach(deprecatedProperty -> {
            if (!hasXmlReport) {
                this.addAnalysisWarning("Property '%s' is deprecated (JaCoCo binary format). '%s' should be used instead (JaCoCo XML format).", deprecatedProperty, JACOCO_XML_PROPERTY);
            } else if (config.hasKey(deprecatedProperty)) {
                JaCoCoExtensions.LOG.info("Both '{}' and '{}' were set. '{}' is deprecated therefore, only '{}' will be taken into account.", new Object[]{deprecatedProperty, JACOCO_XML_PROPERTY, deprecatedProperty, JACOCO_XML_PROPERTY});
            }
        });
    }

    private static boolean hasXmlReport(SensorContext context) {
        return context.config().hasKey(JACOCO_XML_PROPERTY) || Arrays.stream(JACOCO_XML_DEFAULT_PATHS).map(path -> context.fileSystem().baseDir().toPath().resolve((String)path)).anyMatch(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
    }

    private void addAnalysisWarning(String format, Object ... args) {
        String msg = String.format(format, args);
        JaCoCoExtensions.LOG.warn(msg);
        this.analysisWarnings.addUnique(msg);
    }

    private static List<Report> getReportPaths(SensorContext context) {
        ArrayList<Report> reports = new ArrayList<Report>();
        Configuration settings = context.config();
        FileSystem fs = context.fileSystem();
        for (String reportPath : settings.getStringArray("sonar.jacoco.reportPaths")) {
            File report = fs.resolvePath(reportPath);
            if (!report.isFile()) {
                if (!settings.hasKey("sonar.jacoco.reportPaths")) continue;
                JaCoCoExtensions.LOG.info("JaCoCo report not found: '{}'", (Object)reportPath);
                continue;
            }
            reports.add(new Report(report, "sonar.jacoco.reportPaths"));
        }
        JaCoCoSensor.getReport(settings, fs, "sonar.jacoco.reportPath", "JaCoCo UT report not found: '{}'").ifPresent(file -> reports.add(new Report((File)file, "sonar.jacoco.reportPath")));
        JaCoCoSensor.getReport(settings, fs, "sonar.jacoco.itReportPath", "JaCoCo IT report not found: '{}'").ifPresent(file -> reports.add(new Report((File)file, "sonar.jacoco.itReportPath")));
        return reports;
    }

    private static Optional<File> getReport(Configuration settings, FileSystem fs, String reportPathPropertyKey, String msg) {
        Optional reportPathProp = settings.get(reportPathPropertyKey);
        if (reportPathProp.isPresent()) {
            String reportPathProperty = (String)reportPathProp.get();
            File report = fs.resolvePath(reportPathProperty);
            if (!report.isFile()) {
                JaCoCoExtensions.LOG.info(msg, (Object)reportPathProperty);
            } else {
                return Optional.of(report);
            }
        }
        return Optional.empty();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static class Report {
        File file;
        String propertyKey;

        Report(File file, String propertyKey) {
            this.file = file;
            this.propertyKey = propertyKey;
        }
    }
}

