/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.ExecutionDataStore;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.test.MutableTestCase;
import org.sonar.api.test.MutableTestPlan;
import org.sonar.api.test.MutableTestable;
import org.sonar.api.test.Testable;
import org.sonar.api.utils.Version;
import org.sonar.java.AnalysisWarningsWrapper;
import org.sonar.java.JavaClasspath;
import org.sonar.plugins.jacoco.ExecutionDataVisitor;
import org.sonar.plugins.jacoco.JaCoCoExtensions;
import org.sonar.plugins.jacoco.JacocoReportReader;
import org.sonar.plugins.java.api.JavaResourceLocator;

public class UnitTestAnalyzer {
    private final ResourcePerspectives perspectives;
    private final JavaResourceLocator javaResourceLocator;
    private final AnalysisWarningsWrapper analysisWarnings;
    private Map<String, File> classFilesCache;
    private JavaClasspath javaClasspath;
    private JacocoReportReader jacocoReportReader;
    private final File report;
    private boolean supportCoverageByTest;

    public UnitTestAnalyzer(File report, ResourcePerspectives perspectives, JavaResourceLocator javaResourceLocator, JavaClasspath javaClasspath, AnalysisWarningsWrapper analysisWarnings) {
        this.report = report;
        this.perspectives = perspectives;
        this.javaResourceLocator = javaResourceLocator;
        this.javaClasspath = javaClasspath;
        this.analysisWarnings = analysisWarnings;
    }

    private static String fullyQualifiedClassName(String packageName, String simpleClassName) {
        return ("".equals(packageName) ? "" : packageName + "/") + StringUtils.substringBeforeLast((String)simpleClassName, (String)".");
    }

    private InputFile getResource(ISourceFileCoverage coverage) {
        String className = UnitTestAnalyzer.fullyQualifiedClassName(coverage.getPackageName(), coverage.getName());
        InputFile inputFile = this.javaResourceLocator.findResourceByClassName(className);
        if (inputFile == null) {
            return null;
        }
        if (inputFile.type() == InputFile.Type.TEST) {
            return null;
        }
        return inputFile;
    }

    public final void analyse(SensorContext context) {
        this.supportCoverageByTest = !context.getSonarQubeVersion().isGreaterThanOrEqual(Version.create((int)7, (int)7));
        this.classFilesCache = Maps.newHashMap();
        for (File classesDir : this.javaClasspath.getBinaryDirs()) {
            this.populateClassFilesCache(classesDir, "");
        }
        if (this.classFilesCache.isEmpty()) {
            JaCoCoExtensions.LOG.info("No JaCoCo analysis of project coverage can be done since there are no class files.");
            return;
        }
        this.readExecutionData(this.report, context);
        this.classFilesCache = null;
    }

    private void populateClassFilesCache(File dir, String path) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.populateClassFilesCache(file, path + file.getName() + "/");
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String className = path + StringUtils.removeEnd((String)file.getName(), (String)".class");
            this.classFilesCache.put(className, file);
        }
    }

    private void readExecutionData(@Nullable File jacocoExecutionData, SensorContext context) {
        File newJacocoExecutionData = jacocoExecutionData;
        if (newJacocoExecutionData == null || !newJacocoExecutionData.isFile()) {
            JaCoCoExtensions.LOG.info("Project coverage is set to 0% as no JaCoCo execution data has been dumped: {}", (Object)newJacocoExecutionData);
            newJacocoExecutionData = null;
        }
        ExecutionDataVisitor executionDataVisitor = new ExecutionDataVisitor();
        this.jacocoReportReader = new JacocoReportReader(newJacocoExecutionData).readJacocoReport(executionDataVisitor, executionDataVisitor);
        boolean collectedCoveragePerTest = this.readCoveragePerTests(executionDataVisitor);
        CoverageBuilder coverageBuilder = this.jacocoReportReader.analyzeFiles(executionDataVisitor.getMerged(), this.classFilesCache.values());
        int analyzedResources = 0;
        for (ISourceFileCoverage coverage : coverageBuilder.getSourceFiles()) {
            InputFile inputFile = this.getResource(coverage);
            if (inputFile == null) continue;
            NewCoverage newCoverage = context.newCoverage().onFile(inputFile);
            UnitTestAnalyzer.analyzeFile(newCoverage, inputFile, coverage);
            newCoverage.save();
            ++analyzedResources;
        }
        if (analyzedResources == 0) {
            JaCoCoExtensions.LOG.warn("Coverage information was not collected. Perhaps you forget to include debug information into compiled classes?");
        } else if (collectedCoveragePerTest) {
            this.logDeprecationForCoveragePerTest();
        }
    }

    private void logDeprecationForCoveragePerTest() {
        String msg = this.supportCoverageByTest ? "'Coverage per Test' feature is deprecated. Consider removing sonar-jacoco-listeners from your configuration." : "'Coverage per Test' feature was removed from SonarQube. Remove sonar-jacoco-listeners listener configuration.";
        JaCoCoExtensions.LOG.warn(msg);
        this.analysisWarnings.addUnique(msg);
    }

    private boolean readCoveragePerTests(ExecutionDataVisitor executionDataVisitor) {
        boolean collectedCoveragePerTest = false;
        for (Map.Entry<String, ExecutionDataStore> entry : executionDataVisitor.getSessions().entrySet()) {
            if (!this.analyzeLinesCoveredByTests(entry.getKey(), entry.getValue())) continue;
            collectedCoveragePerTest = true;
        }
        return collectedCoveragePerTest;
    }

    private boolean analyzeLinesCoveredByTests(String sessionId, ExecutionDataStore executionDataStore) {
        int i = sessionId.indexOf(32);
        if (i < 0) {
            return false;
        }
        String testClassName = sessionId.substring(0, i);
        String testName = sessionId.substring(i + 1);
        InputFile testResource = this.javaResourceLocator.findResourceByClassName(testClassName);
        if (testResource == null) {
            return false;
        }
        boolean result = false;
        CoverageBuilder coverageBuilder = this.jacocoReportReader.analyzeFiles(executionDataStore, this.classFilesOfStore(executionDataStore));
        for (ISourceFileCoverage coverage : coverageBuilder.getSourceFiles()) {
            List<Integer> coveredLines;
            InputFile resource = this.getResource(coverage);
            if (resource == null || (coveredLines = UnitTestAnalyzer.coveredLines(coverage)).isEmpty() || !this.addCoverage(resource, testResource, testName, coveredLines)) continue;
            result = true;
        }
        return result;
    }

    private Collection<File> classFilesOfStore(ExecutionDataStore executionDataStore) {
        ArrayList result = Lists.newArrayList();
        for (ExecutionData data : executionDataStore.getContents()) {
            String vmClassName = data.getName();
            File classFile = this.classFilesCache.get(vmClassName);
            if (classFile == null) continue;
            result.add(classFile);
        }
        return result;
    }

    private boolean addCoverage(InputFile resource, InputFile testFile, String testName, List<Integer> coveredLines) {
        MutableTestPlan testPlan;
        boolean result = false;
        Testable testAbleFile = (Testable)this.perspectives.as(MutableTestable.class, (InputPath)resource);
        if (testAbleFile != null && (testPlan = (MutableTestPlan)this.perspectives.as(MutableTestPlan.class, (InputPath)testFile)) != null) {
            for (MutableTestCase testCase : testPlan.testCasesByName(testName)) {
                testCase.setCoverageBlock(testAbleFile, coveredLines);
                result = true;
            }
        }
        return result;
    }

    private static List<Integer> coveredLines(ISourceFileCoverage coverage) {
        ArrayList<Integer> coveredLines = new ArrayList<Integer>();
        block4: for (int lineId = coverage.getFirstLine(); lineId <= coverage.getLastLine(); ++lineId) {
            ILine line = coverage.getLine(lineId);
            switch (line.getInstructionCounter().getStatus()) {
                case 2: 
                case 3: {
                    coveredLines.add(lineId);
                    continue block4;
                }
                case 1: {
                    continue block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        return coveredLines;
    }

    private static void analyzeFile(NewCoverage newCoverage, InputFile resource, ISourceFileCoverage coverage) {
        block5: for (int lineId = coverage.getFirstLine(); lineId <= coverage.getLastLine(); ++lineId) {
            int hits;
            ILine line = coverage.getLine(lineId);
            switch (line.getInstructionCounter().getStatus()) {
                case 2: 
                case 3: {
                    hits = 1;
                    break;
                }
                case 1: {
                    hits = 0;
                    break;
                }
                case 0: {
                    continue block5;
                }
                default: {
                    JaCoCoExtensions.LOG.warn("Unknown status for line {} in {}", (Object)lineId, (Object)resource);
                    continue block5;
                }
            }
            newCoverage.lineHits(lineId, hits);
            ICounter branchCounter = line.getBranchCounter();
            int conditions = branchCounter.getTotalCount();
            if (conditions <= 0) continue;
            int coveredConditions = branchCounter.getCoveredCount();
            newCoverage.conditions(lineId, conditions, coveredConditions);
        }
    }
}

