/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.io.File;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.config.Configuration;
import org.sonar.java.JavaClasspath;
import org.sonar.plugins.jacoco.JaCoCoExtensions;
import org.sonar.plugins.jacoco.JaCoCoReportMerger;
import org.sonar.plugins.jacoco.UnitTestAnalyzer;
import org.sonar.plugins.java.api.JavaResourceLocator;

public class JaCoCoSensor
implements Sensor {
    private static final String JACOCO_MERGED_FILENAME = "jacoco-merged.exec";
    private final ResourcePerspectives perspectives;
    private final JavaResourceLocator javaResourceLocator;
    private final JavaClasspath javaClasspath;

    public JaCoCoSensor(ResourcePerspectives perspectives, JavaResourceLocator javaResourceLocator, JavaClasspath javaClasspath) {
        this.perspectives = perspectives;
        this.javaResourceLocator = javaResourceLocator;
        this.javaClasspath = javaClasspath;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("java").name("JaCoCoSensor");
    }

    public void execute(SensorContext context) {
        File reportMerged;
        Set<File> reportPaths;
        if (context.config().hasKey("sonar.jacoco.reportMissing.force.zero")) {
            JaCoCoExtensions.LOG.warn("Property '{}' is deprecated and its value will be ignored.", (Object)"sonar.jacoco.reportMissing.force.zero");
        }
        if ((reportPaths = JaCoCoSensor.getReportPaths(context)).isEmpty()) {
            return;
        }
        if (reportPaths.size() == 1) {
            reportMerged = reportPaths.iterator().next();
        } else {
            reportMerged = new File(context.fileSystem().workDir(), JACOCO_MERGED_FILENAME);
            reportMerged.getParentFile().mkdirs();
            JaCoCoReportMerger.mergeReports(reportMerged, reportPaths.toArray(new File[0]));
        }
        new UnitTestAnalyzer(reportMerged, this.perspectives, this.javaResourceLocator, this.javaClasspath).analyse(context);
    }

    private static Set<File> getReportPaths(SensorContext context) {
        HashSet<File> reportPaths = new HashSet<File>();
        Configuration settings = context.config();
        FileSystem fs = context.fileSystem();
        for (String reportPath : settings.getStringArray("sonar.jacoco.reportPaths")) {
            File report = fs.resolvePath(reportPath);
            if (!report.isFile()) {
                if (!settings.hasKey("sonar.jacoco.reportPaths")) continue;
                JaCoCoExtensions.LOG.info("JaCoCo report not found: '{}'", (Object)reportPath);
                continue;
            }
            reportPaths.add(report);
        }
        JaCoCoSensor.getReport(settings, fs, "sonar.jacoco.reportPath", "JaCoCo UT report not found: '{}'").ifPresent(reportPaths::add);
        JaCoCoSensor.getReport(settings, fs, "sonar.jacoco.itReportPath", "JaCoCo IT report not found: '{}'").ifPresent(reportPaths::add);
        return reportPaths;
    }

    private static Optional<File> getReport(Configuration settings, FileSystem fs, String reportPathPropertyKey, String msg) {
        Optional reportPathProp = settings.get(reportPathPropertyKey);
        if (reportPathProp.isPresent()) {
            JaCoCoSensor.warnUsageOfDeprecatedProperty(settings, reportPathPropertyKey);
            String reportPathProperty = (String)reportPathProp.get();
            File report = fs.resolvePath(reportPathProperty);
            if (!report.isFile()) {
                JaCoCoExtensions.LOG.info(msg, (Object)reportPathProperty);
            } else {
                return Optional.of(report);
            }
        }
        return Optional.empty();
    }

    private static void warnUsageOfDeprecatedProperty(Configuration settings, String reportPathProperty) {
        if (!settings.hasKey("sonar.jacoco.reportPaths")) {
            JaCoCoExtensions.LOG.warn("Property '{}' is deprecated. Please use '{}' instead.", (Object)reportPathProperty, (Object)"sonar.jacoco.reportPaths");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

