/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.surefire.api;

import java.io.File;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.config.Settings;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public final class SurefireUtils {
    private static final Logger LOGGER = Loggers.get(SurefireUtils.class);
    public static final String SUREFIRE_REPORTS_PATH_PROPERTY = "sonar.junit.reportsPath";

    private SurefireUtils() {
    }

    public static File getReportsDirectory(Settings settings, FileSystem fs, PathResolver pathResolver) {
        File dir = SurefireUtils.getReportsDirectoryFromProperty(settings, fs, pathResolver);
        if (dir == null) {
            dir = new File(fs.baseDir(), "target/surefire-reports");
        }
        return dir;
    }

    @CheckForNull
    private static File getReportsDirectoryFromProperty(Settings settings, FileSystem fs, PathResolver pathResolver) {
        String path;
        if (settings.hasKey(SUREFIRE_REPORTS_PATH_PROPERTY) && (path = settings.getString(SUREFIRE_REPORTS_PATH_PROPERTY)) != null) {
            try {
                return pathResolver.relativeFile(fs.baseDir(), path);
            }
            catch (Exception e) {
                LOGGER.info("Surefire report path: " + fs.baseDir() + "/" + path + " not found.");
            }
        }
        return null;
    }
}

