/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.AbstractLanguage;

public class Java
extends AbstractLanguage {
    public static final String KEY = "java";
    public static final String NAME = "Java";
    public static final String FILE_SUFFIXES_KEY = "sonar.java.file.suffixes";
    public static final String DEFAULT_FILE_SUFFIXES = ".java,.jav";
    public static final String SOURCE_VERSION = "sonar.java.source";
    private final Settings settings;

    public Java(Settings settings) {
        super(KEY, NAME);
        this.settings = settings;
    }

    public String[] getFileSuffixes() {
        String[] suffixes = Java.filterEmptyStrings(this.settings.getStringArray(FILE_SUFFIXES_KEY));
        if (suffixes.length == 0) {
            suffixes = StringUtils.split((String)DEFAULT_FILE_SUFFIXES, (String)",");
        }
        return suffixes;
    }

    private static String[] filterEmptyStrings(String[] stringArray) {
        ArrayList nonEmptyStrings = Lists.newArrayList();
        for (String string : stringArray) {
            if (!StringUtils.isNotBlank((String)string.trim())) continue;
            nonEmptyStrings.add(string.trim());
        }
        return nonEmptyStrings.toArray(new String[nonEmptyStrings.size()]);
    }
}

