/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import com.google.common.collect.Lists;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Settings;
import org.sonar.api.design.Dependency;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.graph.DirectedGraph;
import org.sonar.java.DefaultJavaResourceLocator;
import org.sonar.java.JavaClasspath;
import org.sonar.java.JavaConfiguration;
import org.sonar.java.JavaSquid;
import org.sonar.java.Measurer;
import org.sonar.java.SonarComponents;
import org.sonar.java.checks.CheckList;
import org.sonar.plugins.java.api.JavaResourceLocator;
import org.sonar.plugins.java.bridges.DesignBridge;

@Phase(name=Phase.Name.PRE)
@DependsUpon(value={"BEFORE_SQUID"})
@DependedUpon(value={"squid"})
public class JavaSquidSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(JavaSquidSensor.class);
    private final JavaClasspath javaClasspath;
    private final SonarComponents sonarComponents;
    private final FileSystem fs;
    private final DefaultJavaResourceLocator javaResourceLocator;
    private final Settings settings;
    private final NoSonarFilter noSonarFilter;

    public JavaSquidSensor(JavaClasspath javaClasspath, SonarComponents sonarComponents, FileSystem fs, DefaultJavaResourceLocator javaResourceLocator, Settings settings, NoSonarFilter noSonarFilter) {
        this.noSonarFilter = noSonarFilter;
        this.javaClasspath = javaClasspath;
        this.sonarComponents = sonarComponents;
        this.fs = fs;
        this.javaResourceLocator = javaResourceLocator;
        this.settings = settings;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.fs.hasFiles(this.fs.predicates().hasLanguage("java"));
    }

    public void analyse(Project project, SensorContext context) {
        this.javaResourceLocator.setSensorContext(context);
        this.sonarComponents.registerCheckClasses("squid", CheckList.getJavaChecks());
        this.sonarComponents.registerTestCheckClasses("squid", CheckList.getJavaTestChecks());
        JavaConfiguration configuration = this.createConfiguration();
        Measurer measurer = new Measurer(this.fs, context, configuration.separatesAccessorsFromMethods(), this.noSonarFilter);
        JavaSquid squid = new JavaSquid(configuration, this.sonarComponents, measurer, (JavaResourceLocator)this.javaResourceLocator, this.sonarComponents.checkClasses());
        squid.scan(this.getSourceFiles(), this.getTestFiles(), this.getBytecodeFiles());
        boolean skipPackageDesignAnalysis = this.settings.getBoolean("sonar.skipPackageDesign");
        if (!skipPackageDesignAnalysis && squid.isBytecodeScanned()) {
            DesignBridge designBridge = new DesignBridge(context, (DirectedGraph<Resource, Dependency>)squid.getGraph(), this.javaResourceLocator.getResourceMapping(), this.sonarComponents.getResourcePerspectives());
            designBridge.saveDesign(project);
        }
    }

    private Iterable<File> getSourceFiles() {
        return JavaSquidSensor.toFile(this.fs.inputFiles(this.fs.predicates().and(this.fs.predicates().hasLanguage("java"), this.fs.predicates().hasType(InputFile.Type.MAIN))));
    }

    private Iterable<File> getTestFiles() {
        return JavaSquidSensor.toFile(this.fs.inputFiles(this.fs.predicates().and(this.fs.predicates().hasLanguage("java"), this.fs.predicates().hasType(InputFile.Type.TEST))));
    }

    private static Iterable<File> toFile(Iterable<InputFile> inputFiles) {
        ArrayList files = Lists.newArrayList();
        for (InputFile inputFile : inputFiles) {
            files.add(inputFile.file());
        }
        return files;
    }

    private List<File> getBytecodeFiles() {
        if (this.settings.getBoolean("sonar.skipDesign")) {
            return Collections.emptyList();
        }
        return this.javaClasspath.getElements();
    }

    private JavaConfiguration createConfiguration() {
        boolean analyzePropertyAccessors = this.settings.getBoolean("sonar.squid.analyse.property.accessors");
        Charset charset = this.fs.encoding();
        JavaConfiguration conf = new JavaConfiguration(charset);
        conf.setSeparateAccessorsFromMethods(analyzePropertyAccessors);
        Integer javaVersion = this.getJavaVersion();
        LOG.info("Configured Java source version: " + (javaVersion == null ? "none" : javaVersion));
        conf.setJavaVersion(javaVersion);
        return conf;
    }

    @CheckForNull
    private Integer getJavaVersion() {
        String javaVersion = this.settings.getString("sonar.java.source");
        if (javaVersion != null) {
            try {
                return Integer.parseInt(javaVersion.replaceAll("1.", ""));
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid Java version set for property \"sonar.java.source\" (got \"" + javaVersion + "\"). " + "The property will be ignored. Accepted formats are \"1.X\", or simply \"X\" (for instance: \"1.5\" or \"5\", \"1.6\" or \"6\", \"1.7\" or \"7\", etc.)");
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

