/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.verifier;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.fest.assertions.Assertions;
import org.fest.assertions.DoubleAssert;
import org.fest.assertions.IntAssert;
import org.fest.assertions.ListAssert;
import org.fest.assertions.StringAssert;
import org.junit.Assert;
import org.sonar.javascript.checks.verifier.TestIssue;
import org.sonar.javascript.checks.verifier.TestUtils;
import org.sonar.javascript.checks.verifier.TreeCheckTest;
import org.sonar.javascript.visitors.JavaScriptVisitorContext;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.LineIssue;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;
import org.sonar.squidbridge.checks.CheckMessagesVerifier;

public class JavaScriptCheckVerifier
extends SubscriptionVisitorCheck {
    private final List<TestIssue> expectedIssues = new ArrayList<TestIssue>();

    public static CheckMessagesVerifier issues(JavaScriptCheck check, File file) {
        return CheckMessagesVerifier.verify(TreeCheckTest.getIssues(file.getAbsolutePath(), check));
    }

    public static void verify(JavaScriptCheck check, File file) {
        JavaScriptCheckVerifier javaScriptCheckVerifier = new JavaScriptCheckVerifier();
        JavaScriptVisitorContext context = TestUtils.createContext(file);
        javaScriptCheckVerifier.scanFile((TreeVisitorContext)context);
        List<TestIssue> expectedIssues = javaScriptCheckVerifier.expectedIssues;
        Iterator<Issue> actualIssues = JavaScriptCheckVerifier.getActualIssues(check, context);
        for (TestIssue expected : expectedIssues) {
            if (actualIssues.hasNext()) {
                JavaScriptCheckVerifier.verifyIssue(expected, actualIssues.next());
                continue;
            }
            throw new AssertionError((Object)("Missing issue at line " + expected.line()));
        }
        if (actualIssues.hasNext()) {
            Issue issue = actualIssues.next();
            throw new AssertionError((Object)("Unexpected issue at line " + JavaScriptCheckVerifier.line(issue) + ": \"" + JavaScriptCheckVerifier.message(issue) + "\""));
        }
    }

    private static Iterator<Issue> getActualIssues(JavaScriptCheck check, JavaScriptVisitorContext context) {
        List issues = check.scanFile((TreeVisitorContext)context);
        List sortedIssues = Ordering.natural().onResultOf((Function)new IssueToLine()).sortedCopy((Iterable)issues);
        return sortedIssues.iterator();
    }

    private static void verifyIssue(TestIssue expected, Issue actual) {
        if (JavaScriptCheckVerifier.line(actual) > expected.line()) {
            Assert.fail((String)("Missing issue at line " + expected.line()));
        }
        if (JavaScriptCheckVerifier.line(actual) < expected.line()) {
            Assert.fail((String)("Unexpected issue at line " + JavaScriptCheckVerifier.line(actual) + ": \"" + JavaScriptCheckVerifier.message(actual) + "\""));
        }
        if (expected.message() != null) {
            ((StringAssert)Assertions.assertThat((String)JavaScriptCheckVerifier.message(actual)).as("Bad message at line " + expected.line())).isEqualTo((Object)expected.message());
        }
        if (expected.effortToFix() != null) {
            ((DoubleAssert)Assertions.assertThat((Double)actual.cost()).as("Bad effortToFix at line " + expected.line())).isEqualTo((double)expected.effortToFix().intValue());
        }
        if (expected.startColumn() != null) {
            ((IntAssert)Assertions.assertThat((int)(((PreciseIssue)actual).primaryLocation().startLineOffset() + 1)).as("Bad start column at line " + expected.line())).isEqualTo((Object)expected.startColumn());
        }
        if (expected.endColumn() != null) {
            ((IntAssert)Assertions.assertThat((int)(((PreciseIssue)actual).primaryLocation().endLineOffset() + 1)).as("Bad end column at line " + expected.line())).isEqualTo((Object)expected.endColumn());
        }
        if (expected.endLine() != null) {
            ((IntAssert)Assertions.assertThat((int)((PreciseIssue)actual).primaryLocation().endLine()).as("Bad end line at line " + expected.line())).isEqualTo((Object)expected.endLine());
        }
        if (expected.secondaryLines() != null) {
            ((ListAssert)Assertions.assertThat(JavaScriptCheckVerifier.secondary(actual)).as("Bad secondary locations at line " + expected.line())).isEqualTo(expected.secondaryLines());
        }
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TOKEN);
    }

    public void visitNode(Tree tree) {
        SyntaxToken token = (SyntaxToken)tree;
        for (SyntaxTrivia trivia : token.trivias()) {
            int endIndex;
            String marker;
            String text = trivia.text().substring(2).trim();
            if (!text.startsWith(marker = "Noncompliant")) continue;
            TestIssue issue = JavaScriptCheckVerifier.issue(null, trivia.line());
            String paramsAndMessage = text.substring(marker.length()).trim();
            if (paramsAndMessage.startsWith("[[")) {
                endIndex = paramsAndMessage.indexOf("]]");
                JavaScriptCheckVerifier.addParams(issue, paramsAndMessage.substring(2, endIndex));
                paramsAndMessage = paramsAndMessage.substring(endIndex + 2).trim();
            }
            if (paramsAndMessage.startsWith("{{")) {
                endIndex = paramsAndMessage.indexOf("}}");
                String message = paramsAndMessage.substring(2, endIndex);
                issue.message(message);
            }
            this.expectedIssues.add(issue);
        }
    }

    private static void addParams(TestIssue issue, String params) {
        for (String param : Splitter.on((char)';').split((CharSequence)params)) {
            int equalIndex = param.indexOf("=");
            if (equalIndex == -1) {
                throw new IllegalStateException("Invalid param at line 1: " + param);
            }
            String name = param.substring(0, equalIndex);
            String value = param.substring(equalIndex + 1);
            if ("effortToFix".equalsIgnoreCase(name)) {
                issue.effortToFix(Integer.valueOf(value));
                continue;
            }
            if ("sc".equalsIgnoreCase(name)) {
                issue.startColumn(Integer.valueOf(value));
                continue;
            }
            if ("ec".equalsIgnoreCase(name)) {
                issue.endColumn(Integer.valueOf(value));
                continue;
            }
            if ("el".equalsIgnoreCase(name)) {
                issue.endLine(JavaScriptCheckVerifier.lineValue(issue.line(), value));
                continue;
            }
            if ("secondary".equalsIgnoreCase(name)) {
                JavaScriptCheckVerifier.addSecondaryLines(issue, value);
                continue;
            }
            throw new IllegalStateException("Invalid param at line 1: " + name);
        }
    }

    private static void addSecondaryLines(TestIssue issue, String value) {
        ArrayList<Integer> secondaryLines = new ArrayList<Integer>();
        if (!"".equals(value)) {
            for (String secondary : Splitter.on((char)',').split((CharSequence)value)) {
                secondaryLines.add(JavaScriptCheckVerifier.lineValue(issue.line(), secondary));
            }
        }
        issue.secondary(secondaryLines);
    }

    private static int lineValue(int baseLine, String shift) {
        if (shift.startsWith("+")) {
            return baseLine + Integer.valueOf(shift.substring(1));
        }
        if (shift.startsWith("-")) {
            return baseLine - Integer.valueOf(shift.substring(1));
        }
        return Integer.valueOf(shift);
    }

    private static TestIssue issue(@Nullable String message, int lineNumber) {
        return TestIssue.create(message, lineNumber);
    }

    private static int line(Issue issue) {
        if (issue instanceof PreciseIssue) {
            return ((PreciseIssue)issue).primaryLocation().startLine();
        }
        return ((LineIssue)issue).line();
    }

    private static String message(Issue issue) {
        if (issue instanceof PreciseIssue) {
            return ((PreciseIssue)issue).primaryLocation().message();
        }
        return ((LineIssue)issue).message();
    }

    private static List<Integer> secondary(Issue issue) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (issue instanceof PreciseIssue) {
            for (IssueLocation issueLocation : ((PreciseIssue)issue).secondaryLocations()) {
                result.add(issueLocation.startLine());
            }
        }
        return Ordering.natural().sortedCopy(result);
    }

    private static class IssueToLine
    implements Function<Issue, Integer> {
        private IssueToLine() {
        }

        public Integer apply(Issue issue) {
            return JavaScriptCheckVerifier.line(issue);
        }
    }
}

