/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.verifier;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.javascript.checks.verifier.TestIssue;
import org.sonar.javascript.visitors.JavaScriptVisitorContext;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;

class ExpectedIssuesParser
extends SubscriptionVisitorCheck {
    private final List<TestIssue> expectedIssues = new ArrayList<TestIssue>();
    private final List<SyntaxTrivia> preciseSecondaryLocationComments = new ArrayList<SyntaxTrivia>();

    ExpectedIssuesParser() {
    }

    static List<TestIssue> parseExpectedIssues(JavaScriptVisitorContext context) {
        ExpectedIssuesParser expectedIssuesParser = new ExpectedIssuesParser();
        expectedIssuesParser.scanFile((TreeVisitorContext)context);
        expectedIssuesParser.addPreciseSecondaryLocations();
        return expectedIssuesParser.expectedIssues;
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TOKEN);
    }

    public void visitNode(Tree tree) {
        SyntaxToken token = (SyntaxToken)tree;
        for (SyntaxTrivia trivia : token.trivias()) {
            String marker;
            String text = trivia.text().substring(2).trim();
            if (text.startsWith(marker = "Noncompliant")) {
                int endIndex;
                int issueLine = trivia.line();
                String paramsAndMessage = text.substring(marker.length()).trim();
                if (paramsAndMessage.startsWith("@+")) {
                    String[] spaceSplit = paramsAndMessage.split("[\\s\\[{]", 2);
                    issueLine += Integer.valueOf(spaceSplit[0].substring(2)).intValue();
                    paramsAndMessage = spaceSplit.length > 1 ? spaceSplit[1] : "";
                }
                TestIssue issue = ExpectedIssuesParser.issue(null, issueLine);
                if (paramsAndMessage.startsWith("[[")) {
                    endIndex = paramsAndMessage.indexOf("]]");
                    ExpectedIssuesParser.addParams(issue, paramsAndMessage.substring(2, endIndex));
                    paramsAndMessage = paramsAndMessage.substring(endIndex + 2).trim();
                }
                if (paramsAndMessage.startsWith("{{")) {
                    endIndex = paramsAndMessage.indexOf("}}");
                    String message = paramsAndMessage.substring(2, endIndex);
                    issue.message(message);
                }
                this.expectedIssues.add(issue);
                continue;
            }
            if (text.startsWith("^")) {
                this.addPreciseLocation(trivia);
                continue;
            }
            if (!text.startsWith("S ")) continue;
            this.preciseSecondaryLocationComments.add(trivia);
        }
    }

    private void addPreciseSecondaryLocations() {
        for (SyntaxTrivia trivia : this.preciseSecondaryLocationComments) {
            ExpectedIssuesParser.checkPreciseLocationComment(trivia);
            String text = trivia.text();
            int startColumn = text.indexOf(94) + 1;
            int endColumn = text.lastIndexOf(94) + 2;
            String message = null;
            text = text.substring(endColumn).trim();
            if (text.contains("{{")) {
                int endIndex = text.indexOf("}}");
                int startIndex = text.indexOf("{{") + 2;
                message = text.substring(startIndex, endIndex);
                text = text.substring(0, startIndex - 2).trim();
            }
            this.issueByID(text, trivia.line()).secondary(message, trivia.line() - 1, startColumn, endColumn);
        }
    }

    private static void checkPreciseLocationComment(SyntaxTrivia trivia) {
        if (trivia.column() > 1) {
            throw new IllegalStateException("Line " + trivia.line() + ": comments asserting a precise location should start at column 1");
        }
        if (!trivia.text().contains("^")) {
            throw new IllegalStateException("Precise location should contain at least one '^' for comment at line " + trivia.line());
        }
    }

    private static void addParams(TestIssue issue, String params) {
        for (String param : Splitter.on((char)';').split((CharSequence)params)) {
            int equalIndex = ExpectedIssuesParser.getEqualIndex(param, issue);
            String name = param.substring(0, equalIndex);
            String value = param.substring(equalIndex + 1);
            if ("effortToFix".equalsIgnoreCase(name)) {
                issue.effortToFix(Integer.valueOf(value));
                continue;
            }
            if ("sc".equalsIgnoreCase(name)) {
                issue.startColumn(Integer.valueOf(value));
                continue;
            }
            if ("ec".equalsIgnoreCase(name)) {
                issue.endColumn(Integer.valueOf(value));
                continue;
            }
            if ("el".equalsIgnoreCase(name)) {
                issue.endLine(ExpectedIssuesParser.lineValue(issue.line(), value));
                continue;
            }
            if ("secondary".equalsIgnoreCase(name)) {
                ExpectedIssuesParser.addSecondaryLines(issue, value);
                continue;
            }
            if ("id".equalsIgnoreCase(name)) {
                issue.id(value);
                continue;
            }
            throw new IllegalStateException("Invalid param at line " + issue.line() + ": " + name);
        }
    }

    private static int getEqualIndex(String param, TestIssue issue) {
        int equalIndex = param.indexOf(61);
        if (equalIndex == -1) {
            throw new IllegalStateException("Invalid param at line " + issue.line() + ": " + param);
        }
        return equalIndex;
    }

    private static void addSecondaryLines(TestIssue issue, String value) {
        ArrayList<Integer> secondaryLines = new ArrayList<Integer>();
        if (!"".equals(value)) {
            for (String secondary : Splitter.on((char)',').split((CharSequence)value)) {
                secondaryLines.add(ExpectedIssuesParser.lineValue(issue.line(), secondary));
            }
        }
        issue.secondary(secondaryLines);
    }

    private static int lineValue(int baseLine, String shift) {
        if (shift.startsWith("+")) {
            return baseLine + Integer.valueOf(shift.substring(1));
        }
        if (shift.startsWith("-")) {
            return baseLine - Integer.valueOf(shift.substring(1));
        }
        return Integer.valueOf(shift);
    }

    private TestIssue issueByID(String id, int line) {
        for (TestIssue expectedIssue : this.expectedIssues) {
            if (!id.equals(expectedIssue.id())) continue;
            return expectedIssue;
        }
        String format = "Invalid test file: precise secondary location is provided for ID '%s' but no issue is asserted with such ID (line %s)";
        String missingAssertionMessage = String.format(format, id, line);
        throw new IllegalStateException(missingAssertionMessage);
    }

    private void addPreciseLocation(SyntaxTrivia trivia) {
        ExpectedIssuesParser.checkPreciseLocationComment(trivia);
        int line = trivia.line();
        String text = trivia.text();
        String missingAssertionMessage = String.format("Invalid test file: a precise location is provided at line %s but no issue is asserted at line %s", line, line - 1);
        if (this.expectedIssues.isEmpty()) {
            throw new IllegalStateException(missingAssertionMessage);
        }
        TestIssue issue = this.expectedIssues.get(this.expectedIssues.size() - 1);
        if (issue.line() != line - 1) {
            throw new IllegalStateException(missingAssertionMessage);
        }
        issue.endLine(issue.line());
        issue.startColumn(text.indexOf(94) + 1);
        issue.endColumn(text.lastIndexOf(94) + 2);
    }

    private static TestIssue issue(@Nullable String message, int lineNumber) {
        return TestIssue.create(message, lineNumber);
    }
}

