/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.verifier;

import com.google.common.base.Charsets;
import com.sonar.sslr.api.typed.ActionParser;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.sonar.api.config.MapSettings;
import org.sonar.api.config.Settings;
import org.sonar.javascript.parser.JavaScriptParserBuilder;
import org.sonar.javascript.visitors.JavaScriptVisitorContext;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;

class TestUtils {
    protected static final ActionParser<Tree> p = JavaScriptParserBuilder.createParser((Charset)Charsets.UTF_8);

    private TestUtils() {
    }

    public static JavaScriptVisitorContext createContext(File file) {
        ScriptTree scriptTree = (ScriptTree)p.parse(file);
        return new JavaScriptVisitorContext(scriptTree, file, TestUtils.settings());
    }

    public static JavaScriptVisitorContext createParallelContext(File file) {
        ScriptTree scriptTree = (ScriptTree)JavaScriptParserBuilder.createParser((Charset)Charsets.UTF_8).parse(file);
        return new JavaScriptVisitorContext(scriptTree, file, TestUtils.settings());
    }

    private static Settings settings() {
        MapSettings settings = new MapSettings();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("sonar.javascript.jQueryObjectAliases", "$, jQuery");
        properties.put("sonar.javascript.environments", "amd, applescript, atomtest, browser, commonjs, couch, embertest, greasemonkey, jasmine, jest, jquery, meteor, mocha, mongo, nashorn, node, phantomjs, prototypejs, protractor, qunit, rhino, serviceworker, shared-node-browser, shelljs, webextensions, worker, wsh, yui");
        properties.put("sonar.javascript.globals", "sonar.javascript.globals");
        settings.addProperties(properties);
        return settings;
    }
}

