/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.verifier;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.javascript.checks.verifier.ExpectedIssuesParser;
import org.sonar.javascript.checks.verifier.TestIssue;
import org.sonar.javascript.checks.verifier.TestUtils;
import org.sonar.javascript.checks.verifier.TreeCheckTest;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.se.SeChecksDispatcher;
import org.sonar.javascript.visitors.JavaScriptVisitorContext;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.LineIssue;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;
import org.sonar.squidbridge.checks.CheckMessagesVerifier;

public class JavaScriptCheckVerifier {
    private JavaScriptCheckVerifier() {
    }

    public static CheckMessagesVerifier issues(JavaScriptCheck check, File file) {
        return CheckMessagesVerifier.verify(TreeCheckTest.getIssues(file.getAbsolutePath(), check));
    }

    public static void verify(JavaScriptCheck check, File file) {
        JavaScriptCheckVerifier.verify(check, (InputFile)TestUtils.createTestInputFile(file.getAbsolutePath()));
    }

    static void verify(JavaScriptCheck check, InputFile file) {
        JavaScriptVisitorContext context = TestUtils.createContext(file);
        List<TestIssue> expectedIssues = ExpectedIssuesParser.parseExpectedIssues(context);
        Iterator<Issue> actualIssues = JavaScriptCheckVerifier.getActualIssues(check, context);
        for (TestIssue expected : expectedIssues) {
            if (actualIssues.hasNext()) {
                JavaScriptCheckVerifier.verifyIssue(expected, actualIssues.next());
                continue;
            }
            throw new AssertionError((Object)("Missing issue at line " + expected.line()));
        }
        if (actualIssues.hasNext()) {
            Issue issue = actualIssues.next();
            throw new AssertionError((Object)("Unexpected issue at line " + JavaScriptCheckVerifier.line(issue) + ": \"" + JavaScriptCheckVerifier.message(issue) + "\""));
        }
    }

    public static Iterator<Issue> getActualIssues(JavaScriptCheck check, JavaScriptVisitorContext context) {
        JavaScriptCheck checkToRun = check;
        if (check instanceof SeCheck) {
            checkToRun = new SeChecksDispatcher((List)ImmutableList.of((Object)((SeCheck)check)));
        }
        List issues = checkToRun.scanFile((TreeVisitorContext)context);
        List sortedIssues = Ordering.natural().onResultOf((Function)new IssueToLine()).sortedCopy((Iterable)issues);
        return sortedIssues.iterator();
    }

    private static void verifyIssue(TestIssue expected, Issue actual) {
        if (JavaScriptCheckVerifier.line(actual) > expected.line()) {
            Assert.fail((String)("Missing issue at line " + expected.line()));
        }
        if (JavaScriptCheckVerifier.line(actual) < expected.line()) {
            Assert.fail((String)("Unexpected issue at line " + JavaScriptCheckVerifier.line(actual) + ": \"" + JavaScriptCheckVerifier.message(actual) + "\""));
        }
        if (expected.message() != null) {
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)JavaScriptCheckVerifier.message(actual)).as("Bad message at line " + expected.line(), new Object[0])).isEqualTo((Object)expected.message());
        }
        if (expected.effortToFix() != null) {
            ((AbstractDoubleAssert)Assertions.assertThat((Double)actual.cost()).as("Bad effortToFix at line " + expected.line(), new Object[0])).isEqualTo((double)expected.effortToFix().intValue());
        }
        if (expected.startColumn() != null) {
            ((AbstractIntegerAssert)Assertions.assertThat((int)(((PreciseIssue)actual).primaryLocation().startLineOffset() + 1)).as("Bad start column at line " + expected.line(), new Object[0])).isEqualTo((Object)expected.startColumn());
        }
        if (expected.endColumn() != null) {
            ((AbstractIntegerAssert)Assertions.assertThat((int)(((PreciseIssue)actual).primaryLocation().endLineOffset() + 1)).as("Bad end column at line " + expected.line(), new Object[0])).isEqualTo((Object)expected.endColumn());
        }
        if (expected.endLine() != null) {
            ((AbstractIntegerAssert)Assertions.assertThat((int)((PreciseIssue)actual).primaryLocation().endLine()).as("Bad end line at line " + expected.line(), new Object[0])).isEqualTo((Object)expected.endLine());
        }
        if (!expected.secondaryLocations().isEmpty()) {
            JavaScriptCheckVerifier.assertSecondary(actual, expected);
        }
    }

    private static void assertSecondary(Issue actualIssue, TestIssue expectedIssue) {
        List<TestIssue.Location> expectedLocations = expectedIssue.secondaryLocations();
        List<IssueLocation> actualLocations = actualIssue instanceof PreciseIssue ? ((PreciseIssue)actualIssue).secondaryLocations() : new ArrayList();
        String format = "Bad secondary location at line %s (issue at line %s): %s";
        for (TestIssue.Location expected : expectedLocations) {
            IssueLocation actual = JavaScriptCheckVerifier.secondary(expected.line(), actualLocations);
            if (actual != null) {
                if (expected.message() != null) {
                    ((AbstractCharSequenceAssert)Assertions.assertThat((String)actual.message()).as(String.format(format, expected.line(), JavaScriptCheckVerifier.line(actualIssue), "bad message"), new Object[0])).isEqualTo((Object)expected.message());
                }
                if (expected.startColumn() != null) {
                    ((AbstractIntegerAssert)Assertions.assertThat((int)(actual.startLineOffset() + 1)).as(String.format(format, expected.line(), JavaScriptCheckVerifier.line(actualIssue), "bad start column"), new Object[0])).isEqualTo((Object)expected.startColumn());
                    ((AbstractIntegerAssert)Assertions.assertThat((int)(actual.endLineOffset() + 1)).as(String.format(format, expected.line(), JavaScriptCheckVerifier.line(actualIssue), "bad end column"), new Object[0])).isEqualTo((Object)expected.endColumn());
                }
                actualLocations.remove(actual);
                continue;
            }
            throw new AssertionError((Object)("Missing secondary location at line " + expected.line() + " for issue at line " + expectedIssue.line()));
        }
        if (!actualLocations.isEmpty()) {
            IssueLocation location = (IssueLocation)actualLocations.get(0);
            throw new AssertionError((Object)("Unexpected secondary location at line " + location.startLine() + " for issue at line " + JavaScriptCheckVerifier.line(actualIssue)));
        }
    }

    private static IssueLocation secondary(int line, List<IssueLocation> allSecondaryLocations) {
        for (IssueLocation location : allSecondaryLocations) {
            if (location.startLine() != line) continue;
            return location;
        }
        return null;
    }

    private static int line(Issue issue) {
        if (issue instanceof PreciseIssue) {
            return ((PreciseIssue)issue).primaryLocation().startLine();
        }
        return ((LineIssue)issue).line();
    }

    private static String message(Issue issue) {
        if (issue instanceof PreciseIssue) {
            return ((PreciseIssue)issue).primaryLocation().message();
        }
        return ((LineIssue)issue).message();
    }

    private static class IssueToLine
    implements Function<Issue, Integer> {
        private IssueToLine() {
        }

        public Integer apply(Issue issue) {
            return JavaScriptCheckVerifier.line(issue);
        }
    }
}

