/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.verifier;

import java.text.MessageFormat;
import java.util.Arrays;

public class CheckMessage {
    private Integer line;
    private Double cost;
    private final Object check;
    private final String defaultMessage;
    private final Object[] messageArguments;
    private Boolean bypassExclusion;

    public CheckMessage(Object check, String message, Object ... messageArguments) {
        this.check = check;
        this.defaultMessage = message;
        this.messageArguments = messageArguments;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public Integer getLine() {
        return this.line;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public Double getCost() {
        return this.cost;
    }

    public void setBypassExclusion(boolean bypassExclusion) {
        this.bypassExclusion = bypassExclusion;
    }

    public boolean isBypassExclusion() {
        return this.bypassExclusion != null && this.bypassExclusion != false;
    }

    public Object getCheck() {
        return this.check;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public Object[] getMessageArguments() {
        return this.messageArguments;
    }

    public String getText() {
        return this.formatDefaultMessage();
    }

    public String toString() {
        return "CheckMessage{line=" + this.line + ", cost=" + this.cost + ", check=" + this.check + ", defaultMessage='" + this.defaultMessage + '\'' + ", messageArguments=" + Arrays.toString(this.messageArguments) + ", bypassExclusion=" + this.bypassExclusion + '}';
    }

    public String formatDefaultMessage() {
        if (this.messageArguments.length == 0) {
            return this.defaultMessage;
        }
        return MessageFormat.format(this.defaultMessage, this.messageArguments);
    }
}

