/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.verifier;

import java.io.File;
import java.util.Iterator;
import java.util.function.Consumer;
import org.sonar.javascript.checks.verifier.ExpectedIssues;
import org.sonar.javascript.checks.verifier.IssueCollector;
import org.sonar.javascript.checks.verifier.IssueEntry;
import org.sonar.plugins.javascript.api.visitors.Issue;

public class DifferentialIssueCollector
implements IssueCollector {
    private final ExpectedIssues expectedIssues;
    private final Consumer<String> output;

    public DifferentialIssueCollector(ExpectedIssues expectedIssues, Consumer<String> output) {
        this.expectedIssues = expectedIssues;
        this.output = output;
    }

    @Override
    public synchronized void writeIssues(Iterator<Issue> issues, File file) {
        while (issues.hasNext()) {
            Issue issue = issues.next();
            IssueEntry entry = IssueEntry.from(issue, file);
            if (this.expectedIssues.expects(entry)) continue;
            this.output.accept(entry.createExcerpt());
        }
    }

    @Override
    public void writeSummary() {
        this.output.accept(this.expectedIssues.describeMissingExpectations());
    }
}

