/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.verifier;

import com.google.common.base.Throwables;
import com.sonar.sslr.api.typed.ActionParser;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.HashMap;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.TestInputFileBuilder;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.internal.MapSettings;
import org.sonar.javascript.parser.JavaScriptParserBuilder;
import org.sonar.javascript.visitors.JavaScriptVisitorContext;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;

public class TestUtils {
    protected static final ActionParser<Tree> p = TestUtils.newParser();

    private TestUtils() {
    }

    private static ActionParser<Tree> newParser() {
        return JavaScriptParserBuilder.createParser();
    }

    public static JavaScriptVisitorContext createContext(InputFile file) {
        return TestUtils.createContext(file, p);
    }

    public static JavaScriptVisitorContext createParallelContext(InputFile file) {
        return TestUtils.createContext(file, TestUtils.newParser());
    }

    private static JavaScriptVisitorContext createContext(InputFile file, ActionParser<Tree> parser) {
        try {
            ScriptTree scriptTree = (ScriptTree)parser.parse(file.contents());
            return new JavaScriptVisitorContext(scriptTree, file, TestUtils.config());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static Configuration config() {
        MapSettings settings = new MapSettings();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("sonar.javascript.jQueryObjectAliases", "$, jQuery");
        properties.put("sonar.javascript.environments", "amd, applescript, atomtest, browser, commonjs, couch, embertest, flow, greasemonkey, jasmine, jest, jquery, meteor, mocha, mongo, nashorn, node, phantomjs, prototypejs, protractor, qunit, rhino, serviceworker, shared-node-browser, shelljs, webextensions, worker, wsh, yui");
        properties.put("sonar.javascript.globals", "sonar.javascript.globals");
        settings.addProperties(properties);
        return settings.asConfig();
    }

    public static DefaultInputFile createTestInputFile(String baseDir, String relativePath) {
        return new TestInputFileBuilder("module1", relativePath).setModuleBaseDir(Paths.get(baseDir, new String[0])).setLanguage("js").setCharset(StandardCharsets.UTF_8).setType(InputFile.Type.MAIN).build();
    }

    public static DefaultInputFile createTestInputFile(File baseDir, String relativePath) {
        return TestUtils.createTestInputFile(baseDir.getAbsolutePath(), relativePath);
    }

    public static DefaultInputFile createTestInputFile(String relativePath) {
        return TestUtils.createTestInputFile("", relativePath);
    }

    public static DefaultInputFile createTestInputFile(File baseDir, String relativePath, Charset charset) {
        return new TestInputFileBuilder(baseDir.getAbsolutePath(), relativePath).setModuleBaseDir(Paths.get(baseDir.getAbsolutePath(), new String[0])).setLanguage("js").setCharset(charset).build();
    }
}

