/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.verifier;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.javascript.checks.verifier.DifferentialIssueCollector;
import org.sonar.javascript.checks.verifier.IssueCollector;
import org.sonar.javascript.checks.verifier.IssueEntry;
import org.sonar.plugins.javascript.api.visitors.Issue;

public class ExpectedIssueCollector
implements IssueCollector {
    private static final Logger LOGGER = Loggers.get(DifferentialIssueCollector.class);
    private final OutputStreamWriter writer;
    private final File expectedIssuesFile;
    private int nbIssues = 0;
    private int nbFiles = 0;

    public ExpectedIssueCollector(File expectedIssuesFile) throws IOException {
        this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(expectedIssuesFile), "UTF-8");
        this.expectedIssuesFile = expectedIssuesFile;
    }

    @Override
    public synchronized void writeIssues(Iterator<Issue> issues, File file) throws IOException {
        ++this.nbFiles;
        while (issues.hasNext()) {
            Issue issue = issues.next();
            ++this.nbIssues;
            String excerpt = IssueEntry.from(issue, file).createExcerpt();
            this.writer.write(excerpt);
            LOGGER.info(excerpt);
        }
    }

    @Override
    public void writeSummary() throws IOException {
        this.writer.write("\n\nTotal number of issues: " + this.nbIssues + " (on " + this.nbFiles + " scanned files)\n");
        LOGGER.info("Output dumped into file " + this.expectedIssuesFile.getAbsolutePath());
        this.writer.close();
    }
}

