/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.verifier;

import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.time.StopWatch;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.javascript.checks.verifier.IssueCollector;
import org.sonar.javascript.checks.verifier.JavaScriptCheckVerifier;
import org.sonar.javascript.checks.verifier.TestUtils;
import org.sonar.javascript.visitors.JavaScriptVisitorContext;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.visitors.Issue;

public class BulkVerifier {
    private static final Logger LOGGER = Loggers.get(BulkVerifier.class);
    static int margin = 2;
    private final Class<? extends JavaScriptCheck> checkClass;
    private final IssueCollector issueCollector;

    public BulkVerifier(Class<? extends JavaScriptCheck> checkClass, IssueCollector issueCollector) {
        this.checkClass = checkClass;
        this.issueCollector = issueCollector;
    }

    public void scanDirectory(File directory) throws IOException {
        StopWatch timer = new StopWatch();
        timer.start();
        Collection files = FileUtils.listFiles((File)directory, (IOFileFilter)new WildcardFileFilter("*.js"), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        AtomicInteger nbFiles = new AtomicInteger();
        LOGGER.info("Starting to scan the files");
        files.parallelStream().forEach(file -> {
            JavaScriptCheck check = BulkVerifier.instantiateCheck(this.checkClass);
            LOGGER.debug("Processing file " + file);
            DefaultInputFile inputFile = TestUtils.createTestInputFile(directory, directory.toPath().relativize(file.toPath()).toString());
            Iterator<Issue> issues = BulkVerifier.getIssues(check, (InputFile)inputFile);
            try {
                this.issueCollector.writeIssues(issues, (File)file);
            }
            catch (IOException e) {
                LOGGER.error("Failed to generate report for file " + file.getAbsolutePath(), (Throwable)e);
            }
            nbFiles.getAndIncrement();
            if (nbFiles.get() % 200 == 0) {
                LOGGER.info("Processed " + nbFiles + " files. Last file was " + file);
            }
        });
        this.issueCollector.writeSummary();
        timer.stop();
        LOGGER.info("Execution time: " + timer.toString());
    }

    private static Iterator<Issue> getIssues(JavaScriptCheck check, InputFile file) {
        try {
            JavaScriptVisitorContext context = TestUtils.createParallelContext(file);
            return JavaScriptCheckVerifier.getActualIssues(check, context);
        }
        catch (RecognitionException e) {
            LOGGER.info("Parsing failed on file " + file + ". The file is ignored");
            return Collections.emptyIterator();
        }
    }

    private static JavaScriptCheck instantiateCheck(Class<? extends JavaScriptCheck> checkClass) {
        try {
            return checkClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

