/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.verifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

class TestIssue {
    private String id = null;
    private Integer effortToFix = null;
    private Location primaryLocation;
    private List<Location> secondaryLocations = new ArrayList<Location>();

    private TestIssue(@Nullable String message, int line) {
        this.primaryLocation = new Location(message, line);
    }

    public static TestIssue create(@Nullable String message, int lineNumber) {
        return new TestIssue(message, lineNumber);
    }

    public void id(String value) {
        this.id = value;
    }

    public TestIssue message(String message) {
        this.primaryLocation.message = message;
        return this;
    }

    public TestIssue columns(int startColumn, int endColumn) {
        this.startColumn(startColumn);
        this.endColumn(endColumn);
        return this;
    }

    public TestIssue startColumn(int startColumn) {
        this.primaryLocation.startColumn = startColumn;
        return this;
    }

    public TestIssue endColumn(int endColumn) {
        this.primaryLocation.endColumn = endColumn;
        return this;
    }

    public TestIssue effortToFix(int effortToFix) {
        this.effortToFix = effortToFix;
        return this;
    }

    public TestIssue endLine(int endLine) {
        this.primaryLocation.endLine = endLine;
        return this;
    }

    public TestIssue secondary(Integer ... lines) {
        return this.secondary(Arrays.asList(lines));
    }

    public TestIssue secondary(List<Integer> secondaryLines) {
        for (int line : secondaryLines) {
            this.secondaryLocations.add(new Location(null, line));
        }
        return this;
    }

    public TestIssue secondary(@Nullable String message, int line, int startColumn, int endColumn) {
        Location location = new Location(message, line);
        location.startColumn = startColumn;
        location.endColumn = endColumn;
        this.secondaryLocations.add(location);
        return this;
    }

    public int line() {
        return this.primaryLocation.line;
    }

    public Integer startColumn() {
        return this.primaryLocation.startColumn;
    }

    public Integer endLine() {
        return this.primaryLocation.endLine;
    }

    public Integer endColumn() {
        return this.primaryLocation.endColumn;
    }

    public String message() {
        return this.primaryLocation.message;
    }

    public String id() {
        return this.id;
    }

    public Integer effortToFix() {
        return this.effortToFix;
    }

    public List<Location> secondaryLocations() {
        return this.secondaryLocations;
    }

    public static class Location {
        private String message;
        private int line;
        private Integer startColumn = null;
        private Integer endColumn = null;
        private Integer endLine = null;

        private Location(@Nullable String message, int line) {
            this.message = message;
            this.line = line;
        }

        public String message() {
            return this.message;
        }

        public int line() {
            return this.line;
        }

        public Integer startColumn() {
            return this.startColumn;
        }

        public Integer endColumn() {
            return this.endColumn;
        }
    }
}

