/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.verifier;

import com.google.common.base.Objects;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.sonar.javascript.checks.verifier.CheckMessage;

public final class CheckMessagesVerifier {
    private final Iterator<CheckMessage> iterator;
    private CheckMessage current;
    private static final Comparator<CheckMessage> ORDERING = (left, right) -> {
        if (Objects.equal((Object)left.getLine(), (Object)right.getLine())) {
            return left.getDefaultMessage().compareTo(right.getDefaultMessage());
        }
        if (left.getLine() == null) {
            return -1;
        }
        if (right.getLine() == null) {
            return 1;
        }
        return left.getLine().compareTo(right.getLine());
    };

    private CheckMessagesVerifier(Collection<CheckMessage> messages) {
        this.iterator = Ordering.from(ORDERING).sortedCopy(messages).iterator();
    }

    public static CheckMessagesVerifier verify(Collection<CheckMessage> messages) {
        return new CheckMessagesVerifier(messages);
    }

    public CheckMessagesVerifier next() {
        if (!this.iterator.hasNext()) {
            throw new AssertionError((Object)"\nExpected violation");
        }
        this.current = this.iterator.next();
        return this;
    }

    public void noMore() {
        if (this.iterator.hasNext()) {
            CheckMessage next = this.iterator.next();
            throw new AssertionError((Object)("\nNo more violations expected\ngot: at line " + next.getLine()));
        }
    }

    private void checkStateOfCurrent() {
        if (this.current == null) {
            throw new IllegalStateException("Prior to this method you should call next()");
        }
    }

    public CheckMessagesVerifier atLine(@Nullable Integer expectedLine) {
        this.checkStateOfCurrent();
        if (!Objects.equal((Object)expectedLine, (Object)this.current.getLine())) {
            throw CheckMessagesVerifier.assertionError(expectedLine, this.current.getLine());
        }
        return this;
    }

    public CheckMessagesVerifier withMessage(String expectedMessage) {
        this.checkStateOfCurrent();
        String actual = this.current.getText();
        if (!actual.equals(expectedMessage)) {
            throw CheckMessagesVerifier.assertionError("\"" + expectedMessage + "\"", "\"" + actual + "\"");
        }
        return this;
    }

    CheckMessagesVerifier withMessageThat(Matcher<String> matcher) {
        this.checkStateOfCurrent();
        String actual = this.current.getText();
        Assert.assertThat((Object)actual, matcher);
        return this;
    }

    CheckMessagesVerifier withCost(Double expectedCost) {
        this.checkStateOfCurrent();
        if (!Objects.equal((Object)expectedCost, (Object)this.current.getCost())) {
            throw CheckMessagesVerifier.assertionError(expectedCost, this.current.getCost());
        }
        return this;
    }

    private static AssertionError assertionError(@Nullable Object expected, @Nullable Object actual) {
        return new AssertionError((Object)("\nExpected: " + expected + "\ngot: " + actual));
    }
}

