/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.verifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.javascript.checks.verifier.CheckMessage;
import org.sonar.javascript.checks.verifier.TestUtils;
import org.sonar.javascript.visitors.JavaScriptVisitorContext;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.visitors.FileIssue;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.LineIssue;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;

class TreeCheckTest {
    private TreeCheckTest() {
    }

    public static Collection<CheckMessage> getIssues(String relativePath, JavaScriptCheck check) {
        DefaultInputFile file = TestUtils.createTestInputFile(relativePath);
        JavaScriptVisitorContext context = TestUtils.createContext((InputFile)file);
        List issues = check.scanFile((TreeVisitorContext)context);
        return TreeCheckTest.getCheckMessages(issues);
    }

    private static Collection<CheckMessage> getCheckMessages(List<Issue> issues) {
        ArrayList<CheckMessage> checkMessages = new ArrayList<CheckMessage>();
        for (Issue issue : issues) {
            CheckMessage checkMessage;
            if (issue instanceof FileIssue) {
                FileIssue fileIssue = (FileIssue)issue;
                checkMessage = new CheckMessage(fileIssue.check(), fileIssue.message(), new Object[0]);
            } else if (issue instanceof LineIssue) {
                LineIssue lineIssue = (LineIssue)issue;
                checkMessage = new CheckMessage(lineIssue.check(), lineIssue.message(), new Object[0]);
                checkMessage.setLine(lineIssue.line());
            } else {
                PreciseIssue preciseIssue = (PreciseIssue)issue;
                checkMessage = new CheckMessage(preciseIssue.check(), preciseIssue.primaryLocation().message(), new Object[0]);
                checkMessage.setLine(preciseIssue.primaryLocation().startLine());
            }
            if (issue.cost() != null) {
                checkMessage.setCost(issue.cost());
            }
            checkMessages.add(checkMessage);
        }
        return checkMessages;
    }
}

