/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.verifier;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.sonar.javascript.checks.verifier.BulkVerifier;
import org.sonar.plugins.javascript.api.visitors.FileIssue;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.LineIssue;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

public class IssueEntry {
    static final String TAG_END = "#";
    static final String TAG_START = "EXPECTED#";
    private final int startLine;
    private final int endLine;
    private final String message;
    private final File file;
    private final String locationBlurb;

    private IssueEntry(int startLine, int endLine, String message, String locationBlurb, File file) {
        this.startLine = startLine;
        this.endLine = endLine;
        this.message = message;
        this.locationBlurb = locationBlurb;
        this.file = file;
    }

    public static IssueEntry from(Issue issue, File file) {
        if (issue instanceof PreciseIssue) {
            PreciseIssue preciseIssue = (PreciseIssue)issue;
            IssueLocation primaryLocation = preciseIssue.primaryLocation();
            String locationBlurb = "P[" + primaryLocation.startLine() + "/" + primaryLocation.startLineOffset() + "," + primaryLocation.endLine() + "/" + primaryLocation.endLineOffset() + "]";
            return new IssueEntry(primaryLocation.startLine(), primaryLocation.endLine(), primaryLocation.message(), locationBlurb, file);
        }
        if (issue instanceof LineIssue) {
            LineIssue lineIssue = (LineIssue)issue;
            return new IssueEntry(lineIssue.line(), lineIssue.line(), lineIssue.message(), "L[" + lineIssue.line() + "]", file);
        }
        if (issue instanceof FileIssue) {
            FileIssue fileIssue = (FileIssue)issue;
            return new IssueEntry(0, 0, fileIssue.message(), "F", file);
        }
        throw new IllegalArgumentException("Unsupported issue type : " + issue.getClass());
    }

    String createExcerpt() {
        List lines;
        try {
            lines = FileUtils.readLines((File)this.file, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new IllegalStateException("File " + this.file.getAbsolutePath() + " was not available for read", e);
        }
        int excerptStart = Math.max(0, this.startLine - BulkVerifier.margin);
        int excerptEnd = Math.min(lines.size(), this.endLine + BulkVerifier.margin);
        lines.set(this.startLine - 1, (String)lines.get(this.startLine - 1) + "\t\t//" + this.message);
        List<String> excerptLines = lines.subList(excerptStart, excerptEnd);
        excerptLines.add(0, this.printIgnoreTag());
        return excerptLines.stream().collect(Collectors.joining("\n", "\n", "\n"));
    }

    String toId() {
        return this.file.getAbsolutePath() + ": " + this.locationBlurb;
    }

    private String printIgnoreTag() {
        return TAG_START + this.toId() + TAG_END;
    }
}

