/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.verifier;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.javascript.checks.verifier.IssueEntry;

public class ExpectedIssues {
    private Map<String, Boolean> expectedEntries = new HashMap<String, Boolean>();

    public static ExpectedIssues parse(File expectedIssuesFile) throws IOException {
        ExpectedIssues expectedIssues = new ExpectedIssues();
        Pattern pattern = Pattern.compile(".*EXPECTED#(.*)#.*");
        if (expectedIssuesFile.exists()) {
            try (Stream<String> lines = Files.lines(expectedIssuesFile.toPath());){
                lines.forEach(line -> {
                    Matcher matcher = pattern.matcher((CharSequence)line);
                    if (matcher.matches()) {
                        expectedIssues.addExpectation(matcher.group(1));
                    }
                });
            }
        } else {
            expectedIssuesFile.createNewFile();
        }
        return expectedIssues;
    }

    final void addExpectation(String id) {
        this.expectedEntries.put(id, false);
    }

    public boolean expects(IssueEntry issueEntry) {
        if (this.expectedEntries.containsKey(issueEntry.toId())) {
            this.expectedEntries.put(issueEntry.toId(), true);
            return true;
        }
        return false;
    }

    public String describeMissingExpectations() {
        String missingExpectations = this.expectedEntries.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.joining("\n"));
        return "MISSING EXPECTATIONS : \n" + missingExpectations;
    }
}

