/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Collections;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="CollapsibleIfStatements", name="Collapsible \"if\" statements should be merged", priority=Priority.MAJOR, tags={"clumsy"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class CollapsibleIfStatementsCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Merge this if statement with the nested one.";
    private static final String SECONDARY_MESSAGE = "Nested \"if\" statement";

    public void visitIfStatement(IfStatementTree tree) {
        IfStatementTree innerIfStatement;
        if (tree.elseClause() == null && (innerIfStatement = CollapsibleIfStatementsCheck.getCollapsibleIfStatement(tree.statement())) != null) {
            IssueLocation primaryLocation = CollapsibleIfStatementsCheck.issueLocation(tree, MESSAGE);
            IssueLocation secondaryLocation = CollapsibleIfStatementsCheck.issueLocation(innerIfStatement, SECONDARY_MESSAGE);
            this.getContext().addIssue((JavaScriptCheck)this, primaryLocation, Collections.singletonList(secondaryLocation), null);
        }
        super.visitIfStatement(tree);
    }

    private static IssueLocation issueLocation(IfStatementTree tree, String message) {
        return new IssueLocation((Tree)tree.ifKeyword(), (Tree)tree.closeParenthesis(), message);
    }

    @Nullable
    private static IfStatementTree getCollapsibleIfStatement(StatementTree statement) {
        if (statement.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            BlockTree block = (BlockTree)statement;
            if (block.statements().size() == 1) {
                return CollapsibleIfStatementsCheck.getIfStatementWithoutElse((StatementTree)block.statements().get(0));
            }
        } else {
            return CollapsibleIfStatementsCheck.getIfStatementWithoutElse(statement);
        }
        return null;
    }

    @Nullable
    private static IfStatementTree getIfStatementWithoutElse(StatementTree statement) {
        if (statement.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}) && ((IfStatementTree)statement).elseClause() == null) {
            return (IfStatementTree)statement;
        }
        return null;
    }
}

