/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.impl.statement.VariableDeclarationTreeImpl;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.ForInStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForOfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IterationStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2310", name="Loop counters should not be assigned to from within the loop body", priority=Priority.MAJOR, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class CounterUpdatedInLoopCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Remove this assignment of \"%s\".";
    private static final String SECONDARY_MESSAGE = "Counter variable update";
    private Deque<Map<IdentifierTree, IdentifierTree>> writeUsagesOfCounters = new ArrayDeque<Map<IdentifierTree, IdentifierTree>>();
    private Set<IdentifierTree> currentLoopCounters = null;
    private boolean inUpdate = false;
    private static final Tree.Kind[] INC_DEC_OPERATIONS = new Tree.Kind[]{Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT};

    public void visitForStatement(ForStatementTree tree) {
        this.scan(tree.init());
        this.scan((Tree)tree.condition());
        this.currentLoopCounters = new HashSet<IdentifierTree>();
        this.inUpdate = true;
        this.scan((Tree)tree.update());
        this.inUpdate = false;
        this.enterLoopBody();
        this.scan((Tree)tree.statement());
        this.leaveLoopBody();
    }

    public void visitForInStatement(ForInStatementTree tree) {
        this.scan(tree.variableOrExpression());
        this.scan((Tree)tree.expression());
        this.visitObjectIterationStatement((IterationStatementTree)tree, tree.variableOrExpression());
    }

    public void visitForOfStatement(ForOfStatementTree tree) {
        this.scan(tree.variableOrExpression());
        this.scan((Tree)tree.expression());
        this.visitObjectIterationStatement((IterationStatementTree)tree, tree.variableOrExpression());
    }

    public void visitIdentifier(IdentifierTree tree) {
        for (Map<IdentifierTree, IdentifierTree> currentLoopCounterUsages : this.writeUsagesOfCounters) {
            IdentifierTree identifierUsedInUpdateClause = currentLoopCounterUsages.get(tree);
            if (identifierUsedInUpdateClause == null) continue;
            this.raiseIssue(tree, identifierUsedInUpdateClause);
            return;
        }
    }

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if (this.inUpdate && tree.is(INC_DEC_OPERATIONS)) {
            this.addCurrentLoopCounter((Tree)tree.expression());
        }
        super.visitUnaryExpression(tree);
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (this.inUpdate) {
            this.addCurrentLoopCounter((Tree)tree.variable());
        }
        super.visitAssignmentExpression(tree);
    }

    private void addCurrentLoopCounter(Tree tree) {
        if (tree instanceof IdentifierTree) {
            this.currentLoopCounters.add((IdentifierTree)tree);
        }
    }

    private void visitObjectIterationStatement(IterationStatementTree tree, Tree counterBlock) {
        this.currentLoopCounters = new HashSet<IdentifierTree>();
        this.scanCounterBlock(counterBlock);
        this.enterLoopBody();
        this.scan((Tree)tree.statement());
        this.leaveLoopBody();
    }

    private void scanCounterBlock(Tree counterBlock) {
        if (counterBlock instanceof VariableDeclarationTree) {
            for (IdentifierTree identifierTree : ((VariableDeclarationTreeImpl)counterBlock).variableIdentifiers()) {
                this.addCurrentLoopCounter((Tree)identifierTree);
            }
        } else if (counterBlock instanceof AssignmentExpressionTree) {
            this.scanCounterBlock((Tree)((AssignmentExpressionTree)counterBlock).variable());
        } else {
            this.addCurrentLoopCounter(counterBlock);
        }
    }

    private void enterLoopBody() {
        HashMap<IdentifierTree, IdentifierTree> writeUsages = new HashMap<IdentifierTree, IdentifierTree>();
        for (IdentifierTree identifierTree : this.currentLoopCounters) {
            Symbol symbol = identifierTree.symbol();
            if (symbol == null) continue;
            for (Usage usage : symbol.usages()) {
                if (!usage.isWrite()) continue;
                writeUsages.put(usage.identifierTree(), identifierTree);
            }
        }
        this.writeUsagesOfCounters.addLast(writeUsages);
    }

    private void leaveLoopBody() {
        this.writeUsagesOfCounters.removeLast();
    }

    private void raiseIssue(IdentifierTree writeUsage, IdentifierTree identifierUsedInUpdateClause) {
        ImmutableList secondaryLocations = ImmutableList.of((Object)new IssueLocation((Tree)identifierUsedInUpdateClause, SECONDARY_MESSAGE));
        this.getContext().addIssue((JavaScriptCheck)this, new IssueLocation((Tree)writeUsage, String.format(MESSAGE, writeUsage.name())), (List)secondaryLocations, null);
    }
}

