/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionBaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="FunctionDefinitionInsideLoop", name="Functions should not be defined inside loops", priority=Priority.MAJOR, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="30min")
public class FunctionDefinitionInsideLoopCheck
extends SubscriptionBaseTreeVisitor {
    private static final String MESSAGE = "Define this function outside of a loop.";
    private Deque<Integer> scope = new ArrayDeque<Integer>();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object[])CheckUtils.iterationStatementsArray()).add((Object[])new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_DECLARATION}).build();
    }

    public void visitFile(Tree scriptTree) {
        this.scope.clear();
        this.scope.push(0);
    }

    public void visitNode(Tree tree) {
        if (tree.is(CheckUtils.iterationStatementsArray())) {
            this.incrementLoopLevelinScope();
        } else {
            if (this.isInLoop()) {
                this.getContext().addIssue((JavaScriptCheck)this, tree, MESSAGE);
            }
            this.enterScope();
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(CheckUtils.iterationStatementsArray())) {
            this.decrementLoopLevelinScope();
        } else {
            this.scope.pop();
        }
    }

    private void enterScope() {
        this.scope.push(0);
    }

    private void incrementLoopLevelinScope() {
        this.scope.push(this.scope.pop() + 1);
    }

    private void decrementLoopLevelinScope() {
        this.scope.push(this.scope.pop() - 1);
    }

    public boolean isInLoop() {
        return this.scope.peek() > 0;
    }
}

