/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1145", name="Useless \"if(true) {...}\" and \"if(false){...}\" blocks should be removed", priority=Priority.MAJOR, tags={"bug", "cwe", "misra", "security"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class IfConditionalAlwaysTrueOrFalseCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Remove this \"if\" statement.\"";

    public void visitIfStatement(IfStatementTree tree) {
        if (tree.condition().is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree, MESSAGE);
        }
        super.visitIfStatement(tree);
    }
}

