/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.symbols.type.FunctionType;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2234", name="Parameters should be passed in the correct order", priority=Priority.BLOCKER, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class MisorderedParameterListCheck
extends BaseTreeVisitor {
    private static final String MESSAGE_FORMAT = "Arguments to %s have the same names but not the same order as the function parameters.";

    public void visitCallExpression(CallExpressionTree callExpression) {
        List<String> parameterNames;
        FunctionTree functionDeclaration;
        List<String> argumentNames = MisorderedParameterListCheck.names(callExpression.arguments());
        if (argumentNames != null && (functionDeclaration = MisorderedParameterListCheck.functionDeclaration(callExpression)) != null && (parameterNames = MisorderedParameterListCheck.names(functionDeclaration.parameters())) != null && MisorderedParameterListCheck.haveSameNamesAndDifferentOrders(argumentNames, parameterNames)) {
            IssueLocation primaryLocation = new IssueLocation((Tree)callExpression.arguments(), MisorderedParameterListCheck.message(functionDeclaration));
            ImmutableList secondaryLocations = ImmutableList.of((Object)new IssueLocation((Tree)functionDeclaration.parameters()));
            this.getContext().addIssue((JavaScriptCheck)this, primaryLocation, (List)secondaryLocations, null);
        }
        super.visitCallExpression(callExpression);
    }

    @CheckForNull
    private static FunctionTree functionDeclaration(CallExpressionTree tree) {
        TypeSet types = tree.callee().types();
        FunctionType functionType = (FunctionType)types.getUniqueType(Type.Kind.FUNCTION);
        return functionType == null ? null : functionType.functionTree();
    }

    private static boolean haveSameNamesAndDifferentOrders(List<String> argumentNames, List<String> parameterNames) {
        return new HashSet<String>(argumentNames).equals(new HashSet<String>(parameterNames)) && !argumentNames.equals(parameterNames);
    }

    @CheckForNull
    private static List<String> names(ParameterListTree list) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator i$ = list.parameters().iterator();
        while (i$.hasNext()) {
            Tree param;
            Tree paramId = param = (Tree)i$.next();
            if (param.is(new Tree.Kind[]{Tree.Kind.INITIALIZED_BINDING_ELEMENT})) {
                InitializedBindingElementTree initialized = (InitializedBindingElementTree)param;
                paramId = initialized.left();
            }
            if (!paramId.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE, Tree.Kind.BINDING_IDENTIFIER})) {
                return null;
            }
            names.add(((IdentifierTree)paramId).name().toLowerCase());
        }
        return names;
    }

    private static String message(FunctionTree functionDeclaration) {
        String parameter = "this call";
        if (functionDeclaration.is(new Tree.Kind[]{Tree.Kind.FUNCTION_DECLARATION})) {
            parameter = "\"" + ((FunctionDeclarationTree)functionDeclaration).name().name() + "\"";
        }
        return String.format(MESSAGE_FORMAT, parameter);
    }
}

