/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Iterables;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="NonEmptyCaseWithoutBreak", name="Switch cases should end with an unconditional \"break\" statement", priority=Priority.CRITICAL, tags={"cert", "cwe", "misra", "pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class NonEmptyCaseWithoutBreakCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "End this switch case with an unconditional break, continue, return or throw statement.";

    public void visitSwitchStatement(SwitchStatementTree tree) {
        List cases = tree.cases();
        for (int i = 0; i < cases.size() - 1; ++i) {
            SwitchClauseTree switchClauseTree = (SwitchClauseTree)cases.get(i);
            List statements = switchClauseTree.statements();
            if (statements.isEmpty() || this.endsWithJump(statements)) continue;
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)switchClauseTree, MESSAGE);
        }
        super.visitSwitchStatement(tree);
    }

    private boolean endsWithJump(List<StatementTree> statements) {
        if (statements.isEmpty()) {
            return false;
        }
        if (statements.size() == 1 && statements.get(0).is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            BlockTree block = (BlockTree)statements.get(0);
            return this.endsWithJump(block.statements());
        }
        return ((StatementTree)Iterables.getLast(statements)).is(new Tree.Kind[]{Tree.Kind.BREAK_STATEMENT, Tree.Kind.RETURN_STATEMENT, Tree.Kind.THROW_STATEMENT, Tree.Kind.CONTINUE_STATEMENT});
    }
}

