/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractJQuerySelectorOptimizationCheck;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2716", name="Universal selectors should not be used", priority=Priority.MAJOR, tags={"jquery", "performance", "user-experience"})
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleConstantRemediation(value="10min")
public class UniversalSelectorCheck
extends AbstractJQuerySelectorOptimizationCheck {
    private static final String MESSAGE = "Remove the use of this universal selector.";

    @Override
    protected void visitSelector(String selector, CallExpressionTree tree) {
        String[] parts = selector.split("[ >]");
        for (int i = 1; i < parts.length; ++i) {
            if (!"*".equals(parts[i])) continue;
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree, MESSAGE);
            return;
        }
    }
}

